@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin.inputs

import com.pulumi.alicloud.pvtz.inputs.EndpointIpConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cidrBlock The Subnet mask.
 * @property ip The IP address within the parameter range of the subnet mask.  It is recommended to use the IP address assigned by the system.
 * @property vswitchId The Vswitch id.
 * @property zoneId The Zone ID.
 */
public data class EndpointIpConfigArgs(
    public val cidrBlock: Output<String>,
    public val ip: Output<String>? = null,
    public val vswitchId: Output<String>,
    public val zoneId: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.pvtz.inputs.EndpointIpConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.pvtz.inputs.EndpointIpConfigArgs =
        com.pulumi.alicloud.pvtz.inputs.EndpointIpConfigArgs.builder()
            .cidrBlock(cidrBlock.applyValue({ args0 -> args0 }))
            .ip(ip?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId.applyValue({ args0 -> args0 }))
            .zoneId(zoneId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointIpConfigArgs].
 */
@PulumiTagMarker
public class EndpointIpConfigArgsBuilder internal constructor() {
    private var cidrBlock: Output<String>? = null

    private var ip: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The Subnet mask.
     */
    @JvmName("fctogbvnfxgkkaiv")
    public suspend fun cidrBlock(`value`: Output<String>) {
        this.cidrBlock = value
    }

    /**
     * @param value The IP address within the parameter range of the subnet mask.  It is recommended to use the IP address assigned by the system.
     */
    @JvmName("wxrjfooohawtpibx")
    public suspend fun ip(`value`: Output<String>) {
        this.ip = value
    }

    /**
     * @param value The Vswitch id.
     */
    @JvmName("yacqxwjbvdomhvjf")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The Zone ID.
     */
    @JvmName("yoevlkyyntdvgaon")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The Subnet mask.
     */
    @JvmName("yqpwypevxfqafnqt")
    public suspend fun cidrBlock(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cidrBlock = mapped
    }

    /**
     * @param value The IP address within the parameter range of the subnet mask.  It is recommended to use the IP address assigned by the system.
     */
    @JvmName("bxdsebsfwkrdexvl")
    public suspend fun ip(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ip = mapped
    }

    /**
     * @param value The Vswitch id.
     */
    @JvmName("byyjxsdghsxcrbmp")
    public suspend fun vswitchId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The Zone ID.
     */
    @JvmName("cfqfivmyauxuqtor")
    public suspend fun zoneId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): EndpointIpConfigArgs = EndpointIpConfigArgs(
        cidrBlock = cidrBlock ?: throw PulumiNullFieldException("cidrBlock"),
        ip = ip,
        vswitchId = vswitchId ?: throw PulumiNullFieldException("vswitchId"),
        zoneId = zoneId ?: throw PulumiNullFieldException("zoneId"),
    )
}
