@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin.inputs

import com.pulumi.alicloud.pvtz.inputs.GetEndpointsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEndpoints.
 * @property ids A list of Endpoint IDs.
 * @property nameRegex A regex string to filter results by Endpoint name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the resource. Valid values: `CHANGE_FAILED`, `CHANGE_INIT`, `EXCEPTION`, `FAILED`, `INIT`, `SUCCESS`.
 */
public data class GetEndpointsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.pvtz.inputs.GetEndpointsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.pvtz.inputs.GetEndpointsPlainArgs =
        com.pulumi.alicloud.pvtz.inputs.GetEndpointsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEndpointsPlainArgs].
 */
@PulumiTagMarker
public class GetEndpointsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value A list of Endpoint IDs.
     */
    @JvmName("ogqlxpkrqcomvvwf")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Endpoint IDs.
     */
    @JvmName("obgonyyrfvtasffe")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Endpoint name.
     */
    @JvmName("watbuaqydnspwsuk")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("vucfstgldciuqnme")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `CHANGE_FAILED`, `CHANGE_INIT`, `EXCEPTION`, `FAILED`, `INIT`, `SUCCESS`.
     */
    @JvmName("lwhrgcanrwvxegjh")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetEndpointsPlainArgs = GetEndpointsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
