@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin.inputs

import com.pulumi.alicloud.pvtz.inputs.GetResolverZonesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getResolverZones.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the Zone. Valid values: `NORMAL`, `SOLD_OUT`.
 */
public data class GetResolverZonesPlainArgs(
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.pvtz.inputs.GetResolverZonesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.pvtz.inputs.GetResolverZonesPlainArgs =
        com.pulumi.alicloud.pvtz.inputs.GetResolverZonesPlainArgs.builder()
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetResolverZonesPlainArgs].
 */
@PulumiTagMarker
public class GetResolverZonesPlainArgsBuilder internal constructor() {
    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("vbeuothiotschfgp")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the Zone. Valid values: `NORMAL`, `SOLD_OUT`.
     */
    @JvmName("lbpheliobyrapxoh")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetResolverZonesPlainArgs = GetResolverZonesPlainArgs(
        outputFile = outputFile,
        status = status,
    )
}
