@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin.inputs

import com.pulumi.alicloud.pvtz.inputs.GetRulesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRules.
 * @property endpointId The ID of the Endpoint.
 * @property ids A list of Rule IDs.
 * @property nameRegex A regex string to filter results by Rule name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetRulesPlainArgs(
    public val endpointId: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.pvtz.inputs.GetRulesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.pvtz.inputs.GetRulesPlainArgs =
        com.pulumi.alicloud.pvtz.inputs.GetRulesPlainArgs.builder()
            .endpointId(endpointId?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRulesPlainArgs].
 */
@PulumiTagMarker
public class GetRulesPlainArgsBuilder internal constructor() {
    private var endpointId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value The ID of the Endpoint.
     */
    @JvmName("yggtiulpwafnkhop")
    public suspend fun endpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endpointId = mapped
    }

    /**
     * @param value A list of Rule IDs.
     */
    @JvmName("cdftcnxnulffwnfl")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Rule IDs.
     */
    @JvmName("krsgbeelbhujxcuy")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Rule name.
     */
    @JvmName("phfdfwgvljnblrrk")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("mfsgvarpbpolssje")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetRulesPlainArgs = GetRulesPlainArgs(
        endpointId = endpointId,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
