@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin.inputs

import com.pulumi.alicloud.pvtz.inputs.GetZoneRecordsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getZoneRecords.
 * @property ids A list of Private Zone Record IDs.
 * @property keyword Keyword for record rr and value.
 * @property lang User language.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property searchMode Search mode. Value:
 * - LIKE: fuzzy search.
 * - EXACT: precise search. It is not filled in by default.
 * @property status Resolve record status. Value:
 * - ENABLE: enable resolution.
 * - DISABLE: pause parsing.
 * @property tag It is not filled in by default, and queries the current zone resolution records. Fill in "ecs" to query the host name record list under the VPC associated with the current zone.
 * @property userClientIp User ip.
 * @property zoneId ID of the Private Zone.
 */
public data class GetZoneRecordsPlainArgs(
    public val ids: List<String>? = null,
    public val keyword: String? = null,
    public val lang: String? = null,
    public val outputFile: String? = null,
    public val searchMode: String? = null,
    public val status: String? = null,
    public val tag: String? = null,
    public val userClientIp: String? = null,
    public val zoneId: String,
) : ConvertibleToJava<com.pulumi.alicloud.pvtz.inputs.GetZoneRecordsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.pvtz.inputs.GetZoneRecordsPlainArgs =
        com.pulumi.alicloud.pvtz.inputs.GetZoneRecordsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .keyword(keyword?.let({ args0 -> args0 }))
            .lang(lang?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .searchMode(searchMode?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tag(tag?.let({ args0 -> args0 }))
            .userClientIp(userClientIp?.let({ args0 -> args0 }))
            .zoneId(zoneId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetZoneRecordsPlainArgs].
 */
@PulumiTagMarker
public class GetZoneRecordsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var keyword: String? = null

    private var lang: String? = null

    private var outputFile: String? = null

    private var searchMode: String? = null

    private var status: String? = null

    private var tag: String? = null

    private var userClientIp: String? = null

    private var zoneId: String? = null

    /**
     * @param value A list of Private Zone Record IDs.
     */
    @JvmName("ttlchgbyenhcogig")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Private Zone Record IDs.
     */
    @JvmName("uyhdtdubcwmxfrhd")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Keyword for record rr and value.
     */
    @JvmName("vsqcicayvpktwlbf")
    public suspend fun keyword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyword = mapped
    }

    /**
     * @param value User language.
     */
    @JvmName("wthtjejcryqdkwen")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.lang = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ougvscpslkijsrij")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Search mode. Value:
     * - LIKE: fuzzy search.
     * - EXACT: precise search. It is not filled in by default.
     */
    @JvmName("vfstffdwdcuukuka")
    public suspend fun searchMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.searchMode = mapped
    }

    /**
     * @param value Resolve record status. Value:
     * - ENABLE: enable resolution.
     * - DISABLE: pause parsing.
     */
    @JvmName("skpijrjqtkahkbhn")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value It is not filled in by default, and queries the current zone resolution records. Fill in "ecs" to query the host name record list under the VPC associated with the current zone.
     */
    @JvmName("brjyxcfkewymgpla")
    public suspend fun tag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tag = mapped
    }

    /**
     * @param value User ip.
     */
    @JvmName("fqcftgxllvffgyjs")
    public suspend fun userClientIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.userClientIp = mapped
    }

    /**
     * @param value ID of the Private Zone.
     */
    @JvmName("kolxgqbqlbtbtkbg")
    public suspend fun zoneId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.zoneId = mapped
    }

    internal fun build(): GetZoneRecordsPlainArgs = GetZoneRecordsPlainArgs(
        ids = ids,
        keyword = keyword,
        lang = lang,
        outputFile = outputFile,
        searchMode = searchMode,
        status = status,
        tag = tag,
        userClientIp = userClientIp,
        zoneId = zoneId ?: throw PulumiNullFieldException("zoneId"),
    )
}
