@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin.inputs

import com.pulumi.alicloud.pvtz.inputs.GetZonesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getZones.
 * @property enableDetails Default to `false`. Set it to true can output more details.
 * @property ids A list of zone IDs.
 * @property keyword keyword for zone name.
 * @property lang User language.
 * @property nameRegex
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property queryRegionId query_region_id for zone regionId.
 * @property queryVpcId query_vpc_id for zone vpcId.
 * @property resourceGroupId resource_group_id for zone resourceGroupId.
 * @property searchMode Search mode. Value:
 * - LIKE: fuzzy search.
 * - EXACT: precise search. It is not filled in by default.
 */
public data class GetZonesPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val keyword: String? = null,
    public val lang: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val queryRegionId: String? = null,
    public val queryVpcId: String? = null,
    public val resourceGroupId: String? = null,
    public val searchMode: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.pvtz.inputs.GetZonesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.pvtz.inputs.GetZonesPlainArgs =
        com.pulumi.alicloud.pvtz.inputs.GetZonesPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .keyword(keyword?.let({ args0 -> args0 }))
            .lang(lang?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .queryRegionId(queryRegionId?.let({ args0 -> args0 }))
            .queryVpcId(queryVpcId?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .searchMode(searchMode?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetZonesPlainArgs].
 */
@PulumiTagMarker
public class GetZonesPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var keyword: String? = null

    private var lang: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var queryRegionId: String? = null

    private var queryVpcId: String? = null

    private var resourceGroupId: String? = null

    private var searchMode: String? = null

    /**
     * @param value Default to `false`. Set it to true can output more details.
     */
    @JvmName("rxamaikjxmqgviaf")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of zone IDs.
     */
    @JvmName("tkkqpqljcefgfcpi")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of zone IDs.
     */
    @JvmName("heahurmsamesggul")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value keyword for zone name.
     */
    @JvmName("hdqodlycaabpiaxi")
    public suspend fun keyword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyword = mapped
    }

    /**
     * @param value User language.
     */
    @JvmName("nluggkyqpbjqpkdg")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.lang = mapped
    }

    /**
     * @param value
     */
    @JvmName("pcyqxqrqkxkohjiv")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("roewdnunlmdcbeoy")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value query_region_id for zone regionId.
     */
    @JvmName("ikefovuedltxmglx")
    public suspend fun queryRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.queryRegionId = mapped
    }

    /**
     * @param value query_vpc_id for zone vpcId.
     */
    @JvmName("gvsfvmwlycxeqwob")
    public suspend fun queryVpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.queryVpcId = mapped
    }

    /**
     * @param value resource_group_id for zone resourceGroupId.
     */
    @JvmName("jcrjjkirukewtdev")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Search mode. Value:
     * - LIKE: fuzzy search.
     * - EXACT: precise search. It is not filled in by default.
     */
    @JvmName("gekjlkcjryhhfdrw")
    public suspend fun searchMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.searchMode = mapped
    }

    internal fun build(): GetZonesPlainArgs = GetZonesPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        keyword = keyword,
        lang = lang,
        nameRegex = nameRegex,
        outputFile = outputFile,
        queryRegionId = queryRegionId,
        queryVpcId = queryVpcId,
        resourceGroupId = resourceGroupId,
        searchMode = searchMode,
    )
}
