@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin.inputs

import com.pulumi.alicloud.pvtz.inputs.RuleAttachmentVpcArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property regionId The region of the vpc. If not set, the current region will instead of.
 * @property vpcId The ID of the VPC.  **NOTE:** The VPC that can be associated with the forwarding rule must belong to the same region as the Endpoint.
 */
public data class RuleAttachmentVpcArgs(
    public val regionId: Output<String>,
    public val vpcId: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.pvtz.inputs.RuleAttachmentVpcArgs> {
    override fun toJava(): com.pulumi.alicloud.pvtz.inputs.RuleAttachmentVpcArgs =
        com.pulumi.alicloud.pvtz.inputs.RuleAttachmentVpcArgs.builder()
            .regionId(regionId.applyValue({ args0 -> args0 }))
            .vpcId(vpcId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleAttachmentVpcArgs].
 */
@PulumiTagMarker
public class RuleAttachmentVpcArgsBuilder internal constructor() {
    private var regionId: Output<String>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The region of the vpc. If not set, the current region will instead of.
     */
    @JvmName("mikrcykksufjfikl")
    public suspend fun regionId(`value`: Output<String>) {
        this.regionId = value
    }

    /**
     * @param value The ID of the VPC.  **NOTE:** The VPC that can be associated with the forwarding rule must belong to the same region as the Endpoint.
     */
    @JvmName("undmkkmghdnkjnhh")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The region of the vpc. If not set, the current region will instead of.
     */
    @JvmName("brlibojgcghhqfkx")
    public suspend fun regionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionId = mapped
    }

    /**
     * @param value The ID of the VPC.  **NOTE:** The VPC that can be associated with the forwarding rule must belong to the same region as the Endpoint.
     */
    @JvmName("aekbwbnxgnmjapho")
    public suspend fun vpcId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): RuleAttachmentVpcArgs = RuleAttachmentVpcArgs(
        regionId = regionId ?: throw PulumiNullFieldException("regionId"),
        vpcId = vpcId ?: throw PulumiNullFieldException("vpcId"),
    )
}
