@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin.inputs

import com.pulumi.alicloud.pvtz.inputs.RuleForwardIpArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ip The ip of the forwarding destination.
 * @property port The port of the forwarding destination.
 */
public data class RuleForwardIpArgs(
    public val ip: Output<String>,
    public val port: Output<Int>,
) : ConvertibleToJava<com.pulumi.alicloud.pvtz.inputs.RuleForwardIpArgs> {
    override fun toJava(): com.pulumi.alicloud.pvtz.inputs.RuleForwardIpArgs =
        com.pulumi.alicloud.pvtz.inputs.RuleForwardIpArgs.builder()
            .ip(ip.applyValue({ args0 -> args0 }))
            .port(port.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleForwardIpArgs].
 */
@PulumiTagMarker
public class RuleForwardIpArgsBuilder internal constructor() {
    private var ip: Output<String>? = null

    private var port: Output<Int>? = null

    /**
     * @param value The ip of the forwarding destination.
     */
    @JvmName("yfnobstatfwiofdp")
    public suspend fun ip(`value`: Output<String>) {
        this.ip = value
    }

    /**
     * @param value The port of the forwarding destination.
     */
    @JvmName("obgqwlplfhprnpgu")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The ip of the forwarding destination.
     */
    @JvmName("mkrlppmytxutpnlg")
    public suspend fun ip(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ip = mapped
    }

    /**
     * @param value The port of the forwarding destination.
     */
    @JvmName("oqyuwrxifarurbug")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): RuleForwardIpArgs = RuleForwardIpArgs(
        ip = ip ?: throw PulumiNullFieldException("ip"),
        port = port ?: throw PulumiNullFieldException("port"),
    )
}
