@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin.inputs

import com.pulumi.alicloud.pvtz.inputs.ZoneAttachmentVpcArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property regionId The region of the vpc. If not set, the current region will instead of.
 * @property vpcId The Id of the vpc.
 */
public data class ZoneAttachmentVpcArgs(
    public val regionId: Output<String>? = null,
    public val vpcId: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.pvtz.inputs.ZoneAttachmentVpcArgs> {
    override fun toJava(): com.pulumi.alicloud.pvtz.inputs.ZoneAttachmentVpcArgs =
        com.pulumi.alicloud.pvtz.inputs.ZoneAttachmentVpcArgs.builder()
            .regionId(regionId?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ZoneAttachmentVpcArgs].
 */
@PulumiTagMarker
public class ZoneAttachmentVpcArgsBuilder internal constructor() {
    private var regionId: Output<String>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The region of the vpc. If not set, the current region will instead of.
     */
    @JvmName("ofllqxxbgywsrchl")
    public suspend fun regionId(`value`: Output<String>) {
        this.regionId = value
    }

    /**
     * @param value The Id of the vpc.
     */
    @JvmName("oikoatedumqkpdto")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The region of the vpc. If not set, the current region will instead of.
     */
    @JvmName("fcvmlwjoomcllilq")
    public suspend fun regionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionId = mapped
    }

    /**
     * @param value The Id of the vpc.
     */
    @JvmName("nulfdkcymkpyfmqi")
    public suspend fun vpcId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): ZoneAttachmentVpcArgs = ZoneAttachmentVpcArgs(
        regionId = regionId,
        vpcId = vpcId ?: throw PulumiNullFieldException("vpcId"),
    )
}
