@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin.inputs

import com.pulumi.alicloud.pvtz.inputs.ZoneUserInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property regionIds The list of the region IDs.
 * @property userId The user ID belonging to the region is used for cross-account synchronization scenarios.
 */
public data class ZoneUserInfoArgs(
    public val regionIds: Output<List<String>>? = null,
    public val userId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.pvtz.inputs.ZoneUserInfoArgs> {
    override fun toJava(): com.pulumi.alicloud.pvtz.inputs.ZoneUserInfoArgs =
        com.pulumi.alicloud.pvtz.inputs.ZoneUserInfoArgs.builder()
            .regionIds(regionIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .userId(userId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ZoneUserInfoArgs].
 */
@PulumiTagMarker
public class ZoneUserInfoArgsBuilder internal constructor() {
    private var regionIds: Output<List<String>>? = null

    private var userId: Output<String>? = null

    /**
     * @param value The list of the region IDs.
     */
    @JvmName("nqtgaktvtltcvnxs")
    public suspend fun regionIds(`value`: Output<List<String>>) {
        this.regionIds = value
    }

    @JvmName("lwmowrqcihyjmcob")
    public suspend fun regionIds(vararg values: Output<String>) {
        this.regionIds = Output.all(values.asList())
    }

    /**
     * @param values The list of the region IDs.
     */
    @JvmName("vmtnpbenhqgidtfv")
    public suspend fun regionIds(values: List<Output<String>>) {
        this.regionIds = Output.all(values)
    }

    /**
     * @param value The user ID belonging to the region is used for cross-account synchronization scenarios.
     */
    @JvmName("pnpyebqawjkaodsq")
    public suspend fun userId(`value`: Output<String>) {
        this.userId = value
    }

    /**
     * @param value The list of the region IDs.
     */
    @JvmName("mdxfjrxixbwarivh")
    public suspend fun regionIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionIds = mapped
    }

    /**
     * @param values The list of the region IDs.
     */
    @JvmName("phpsuybcbpoceiqy")
    public suspend fun regionIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionIds = mapped
    }

    /**
     * @param value The user ID belonging to the region is used for cross-account synchronization scenarios.
     */
    @JvmName("kixufckcxpkrhovh")
    public suspend fun userId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userId = mapped
    }

    internal fun build(): ZoneUserInfoArgs = ZoneUserInfoArgs(
        regionIds = regionIds,
        userId = userId,
    )
}
