@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cidrBlock The Subnet mask.
 * @property ip The IP address within the parameter range of the subnet mask.  It is recommended to use the IP address assigned by the system.
 * @property vswitchId The Vswitch id.
 * @property zoneId The Zone ID.
 */
public data class EndpointIpConfig(
    public val cidrBlock: String,
    public val ip: String? = null,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.pvtz.outputs.EndpointIpConfig): EndpointIpConfig = EndpointIpConfig(
            cidrBlock = javaType.cidrBlock(),
            ip = javaType.ip().map({ args0 -> args0 }).orElse(null),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
