@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property createTime The creation time of the resource.
 * @property endpointName The name of the resource.
 * @property id
 * @property ipConfigs The Ip Configs.
 * @property securityGroupId The ID of the Security Group.
 * @property status The status of the resource. Valid values: `CHANGE_FAILED`, `CHANGE_INIT`, `EXCEPTION`, `FAILED`, `INIT`, `SUCCESS`.
 * @property vpcId The VPC ID.
 * @property vpcName The name of the VPC.
 * @property vpcRegionId The Region of the VPC.
 */
public data class GetEndpointsEndpoint(
    public val createTime: String,
    public val endpointName: String,
    public val id: String,
    public val ipConfigs: List<GetEndpointsEndpointIpConfig>,
    public val securityGroupId: String,
    public val status: String,
    public val vpcId: String,
    public val vpcName: String,
    public val vpcRegionId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.pvtz.outputs.GetEndpointsEndpoint): GetEndpointsEndpoint = GetEndpointsEndpoint(
            createTime = javaType.createTime(),
            endpointName = javaType.endpointName(),
            id = javaType.id(),
            ipConfigs = javaType.ipConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.pvtz.kotlin.outputs.GetEndpointsEndpointIpConfig.Companion.toKotlin(args0)
                })
            }),
            securityGroupId = javaType.securityGroupId(),
            status = javaType.status(),
            vpcId = javaType.vpcId(),
            vpcName = javaType.vpcName(),
            vpcRegionId = javaType.vpcRegionId(),
        )
    }
}
