@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getResolverZones.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property outputFile
 * @property status
 * @property zones
 */
public data class GetResolverZonesResult(
    public val id: String,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val zones: List<GetResolverZonesZone>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.pvtz.outputs.GetResolverZonesResult): GetResolverZonesResult = GetResolverZonesResult(
            id = javaType.id(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            zones = javaType.zones().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.pvtz.kotlin.outputs.GetResolverZonesZone.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
