@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property bindVpcs The List of the VPC. See the following `Block bind_vpcs`. **NOTE:** Available in v1.158.0+.
 * @property createTime The creation time of the resource.
 * @property endpointId The ID of the Endpoint.
 * @property endpointName The Name of the Endpoint.
 * @property forwardIps
 * @property id The ID of the Rule.
 * @property ruleId The first ID of the resource.
 * @property ruleName The name of the resource.
 * @property type The type of the rule.
 * @property zoneName The name of the forwarding zone.
 */
public data class GetRulesRule(
    public val bindVpcs: List<GetRulesRuleBindVpc>,
    public val createTime: String,
    public val endpointId: String,
    public val endpointName: String,
    public val forwardIps: List<GetRulesRuleForwardIp>,
    public val id: String,
    public val ruleId: String,
    public val ruleName: String,
    public val type: String,
    public val zoneName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.pvtz.outputs.GetRulesRule): GetRulesRule =
            GetRulesRule(
                bindVpcs = javaType.bindVpcs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.pvtz.kotlin.outputs.GetRulesRuleBindVpc.Companion.toKotlin(args0)
                    })
                }),
                createTime = javaType.createTime(),
                endpointId = javaType.endpointId(),
                endpointName = javaType.endpointName(),
                forwardIps = javaType.forwardIps().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.pvtz.kotlin.outputs.GetRulesRuleForwardIp.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                ruleId = javaType.ruleId(),
                ruleName = javaType.ruleName(),
                type = javaType.type(),
                zoneName = javaType.zoneName(),
            )
    }
}
