@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id ID of the Private Zone Record.
 * @property priority Priority of the Private Zone Record.
 * @property recordId RecordId of the Private Zone Record.
 * @property remark Remark of the Private Zone Record.
 * @property resourceRecord Resource record of the Private Zone Record.
 * @property rr Rr of the Private Zone Record.
 * @property status Resolve record status. Value:
 * - ENABLE: enable resolution.
 * - DISABLE: pause parsing.
 * @property ttl Ttl of the Private Zone Record.
 * @property type Type of the Private Zone Record.
 * @property value Value of the Private Zone Record.
 */
public data class GetZoneRecordsRecord(
    public val id: String,
    public val priority: Int,
    public val recordId: String,
    public val remark: String,
    public val resourceRecord: String,
    public val rr: String,
    public val status: String,
    public val ttl: Int,
    public val type: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.pvtz.outputs.GetZoneRecordsRecord): GetZoneRecordsRecord = GetZoneRecordsRecord(
            id = javaType.id(),
            priority = javaType.priority(),
            recordId = javaType.recordId(),
            remark = javaType.remark(),
            resourceRecord = javaType.resourceRecord(),
            rr = javaType.rr(),
            status = javaType.status(),
            ttl = javaType.ttl(),
            type = javaType.type(),
            `value` = javaType.`value`(),
        )
    }
}
