@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getZoneRecords.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Private Zone Record IDs.
 * @property keyword
 * @property lang
 * @property outputFile
 * @property records A list of zone records. Each element contains the following attributes:
 * @property searchMode
 * @property status Status of the Private Zone Record.
 * @property tag
 * @property userClientIp
 * @property zoneId
 */
public data class GetZoneRecordsResult(
    public val id: String,
    public val ids: List<String>,
    public val keyword: String? = null,
    public val lang: String? = null,
    public val outputFile: String? = null,
    public val records: List<GetZoneRecordsRecord>,
    public val searchMode: String? = null,
    public val status: String? = null,
    public val tag: String? = null,
    public val userClientIp: String? = null,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.pvtz.outputs.GetZoneRecordsResult): GetZoneRecordsResult = GetZoneRecordsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            keyword = javaType.keyword().map({ args0 -> args0 }).orElse(null),
            lang = javaType.lang().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            records = javaType.records().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.pvtz.kotlin.outputs.GetZoneRecordsRecord.Companion.toKotlin(args0)
                })
            }),
            searchMode = javaType.searchMode().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tag = javaType.tag().map({ args0 -> args0 }).orElse(null),
            userClientIp = javaType.userClientIp().map({ args0 -> args0 }).orElse(null),
            zoneId = javaType.zoneId(),
        )
    }
}
