@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getZones.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of zone IDs.
 * @property keyword
 * @property lang
 * @property nameRegex
 * @property names A list of zone names.
 * @property outputFile
 * @property queryRegionId
 * @property queryVpcId
 * @property resourceGroupId The Id of resource group which the Private Zone belongs.
 * @property searchMode
 * @property zones A list of zones. Each element contains the following attributes:
 */
public data class GetZonesResult(
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val keyword: String? = null,
    public val lang: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val queryRegionId: String? = null,
    public val queryVpcId: String? = null,
    public val resourceGroupId: String? = null,
    public val searchMode: String? = null,
    public val zones: List<GetZonesZone>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.pvtz.outputs.GetZonesResult): GetZonesResult =
            GetZonesResult(
                enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                keyword = javaType.keyword().map({ args0 -> args0 }).orElse(null),
                lang = javaType.lang().map({ args0 -> args0 }).orElse(null),
                nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
                names = javaType.names().map({ args0 -> args0 }),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
                queryRegionId = javaType.queryRegionId().map({ args0 -> args0 }).orElse(null),
                queryVpcId = javaType.queryVpcId().map({ args0 -> args0 }).orElse(null),
                resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
                searchMode = javaType.searchMode().map({ args0 -> args0 }).orElse(null),
                zones = javaType.zones().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.pvtz.kotlin.outputs.GetZonesZone.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
