@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property bindVpcs List of the VPCs is bound to the Private Zone:
 * @property createTimestamp Time of create of the Private Zone.
 * @property creationTime
 * @property id ID of the Private Zone.
 * @property isPtr Whether the Private Zone is ptr.
 * @property name Name of the Private Zone.
 * @property proxyPattern The recursive DNS proxy.
 * @property recordCount Count of the Private Zone Record.
 * @property remark Remark of the Private Zone.
 * @property resourceGroupId resource_group_id for zone resourceGroupId.
 * @property slaveDns Whether to turn on secondary DNS.
 * @property updateTime
 * @property updateTimestamp Time of update of the Private Zone.
 * @property zoneId ZoneId of the Private Zone.
 * @property zoneName ZoneName of the Private Zone.
 */
public data class GetZonesZone(
    public val bindVpcs: List<GetZonesZoneBindVpc>,
    public val createTimestamp: Int,
    public val creationTime: String,
    public val id: String,
    public val isPtr: Boolean,
    public val name: String,
    public val proxyPattern: String,
    public val recordCount: Int,
    public val remark: String,
    public val resourceGroupId: String,
    public val slaveDns: Boolean,
    public val updateTime: String,
    public val updateTimestamp: Int,
    public val zoneId: String,
    public val zoneName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.pvtz.outputs.GetZonesZone): GetZonesZone =
            GetZonesZone(
                bindVpcs = javaType.bindVpcs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.pvtz.kotlin.outputs.GetZonesZoneBindVpc.Companion.toKotlin(args0)
                    })
                }),
                createTimestamp = javaType.createTimestamp(),
                creationTime = javaType.creationTime(),
                id = javaType.id(),
                isPtr = javaType.isPtr(),
                name = javaType.name(),
                proxyPattern = javaType.proxyPattern(),
                recordCount = javaType.recordCount(),
                remark = javaType.remark(),
                resourceGroupId = javaType.resourceGroupId(),
                slaveDns = javaType.slaveDns(),
                updateTime = javaType.updateTime(),
                updateTimestamp = javaType.updateTimestamp(),
                zoneId = javaType.zoneId(),
                zoneName = javaType.zoneName(),
            )
    }
}
