@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property regionId The region of the vpc. If not set, the current region will instead of.
 * @property vpcId The ID of the VPC.  **NOTE:** The VPC that can be associated with the forwarding rule must belong to the same region as the Endpoint.
 */
public data class RuleAttachmentVpc(
    public val regionId: String,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.pvtz.outputs.RuleAttachmentVpc): RuleAttachmentVpc = RuleAttachmentVpc(
            regionId = javaType.regionId(),
            vpcId = javaType.vpcId(),
        )
    }
}
