@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property regionIds The list of the region IDs.
 * @property userId The user ID belonging to the region is used for cross-account synchronization scenarios.
 */
public data class ZoneUserInfo(
    public val regionIds: List<String>? = null,
    public val userId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.pvtz.outputs.ZoneUserInfo): ZoneUserInfo =
            ZoneUserInfo(
                regionIds = javaType.regionIds().map({ args0 -> args0 }),
                userId = javaType.userId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
