@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quickbi.kotlin

import com.pulumi.alicloud.quickbi.QuickbiFunctions.getUsersPlain
import com.pulumi.alicloud.quickbi.kotlin.inputs.GetUsersPlainArgs
import com.pulumi.alicloud.quickbi.kotlin.inputs.GetUsersPlainArgsBuilder
import com.pulumi.alicloud.quickbi.kotlin.outputs.GetUsersResult
import com.pulumi.alicloud.quickbi.kotlin.outputs.GetUsersResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

public object QuickbiFunctions {
    /**
     * This data source provides the Quick BI Users of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.136.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.quickbi.getUsers({
     *     ids: ["example_id"],
     * });
     * export const quickBiUserId1 = ids.then(ids => ids.users?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.quickbi.get_users(ids=["example_id"])
     * pulumi.export("quickBiUserId1", ids.users[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.QuickBI.GetUsers.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["quickBiUserId1"] = ids&#46;Apply(getUsersResult => getUsersResult&#46;Users[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/quickbi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := quickbi.GetUsers(ctx, &quickbi.GetUsersArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("quickBiUserId1", ids.Users[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.quickbi.QuickbiFunctions;
     * import com.pulumi.alicloud.quickbi.inputs.GetUsersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = QuickbiFunctions.getUsers(GetUsersArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("quickBiUserId1", ids.applyValue(getUsersResult -> getUsersResult.users()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:quickbi:getUsers
     *       Arguments:
     *         ids:
     *           - example_id
     * outputs:
     *   quickBiUserId1: ${ids.users[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getUsers.
     * @return A collection of values returned by getUsers.
     */
    public suspend fun getUsers(argument: GetUsersPlainArgs): GetUsersResult =
        toKotlin(getUsersPlain(argument.toJava()).await())

    /**
     * @see [getUsers].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of User IDs.
     * @param keyword The keywords of the nicknames or usernames of the members of the organization.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getUsers.
     */
    public suspend fun getUsers(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        keyword: String? = null,
        outputFile: String? = null,
    ): GetUsersResult {
        val argument = GetUsersPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            keyword = keyword,
            outputFile = outputFile,
        )
        return toKotlin(getUsersPlain(argument.toJava()).await())
    }

    /**
     * @see [getUsers].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;quickbi&#46;kotlin&#46;inputs&#46;GetUsersPlainArgs].
     * @return A collection of values returned by getUsers.
     */
    public suspend fun getUsers(argument: suspend GetUsersPlainArgsBuilder.() -> Unit): GetUsersResult {
        val builder = GetUsersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getUsersPlain(builtArgument.toJava()).await())
    }
}
