@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quickbi.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [User].
 */
@PulumiTagMarker
public class UserResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserArgs = UserArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserArgsBuilder.() -> Unit) {
        val builder = UserArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): User {
        val builtJavaResource = com.pulumi.alicloud.quickbi.User(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return User(builtJavaResource)
    }
}

/**
 * Provides a Quick BI User resource.
 * For information about Quick BI User and how to use it, see [What is User](https://www.alibabacloud.com/help/doc-detail/33813.htm).
 * > **NOTE:** Available in v1.136.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.quickbi.User("example", {
 *     accountName: "example_value",
 *     adminUser: false,
 *     authAdminUser: false,
 *     nickName: "example_value",
 *     userType: "Analyst",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.quickbi.User("example",
 *     account_name="example_value",
 *     admin_user=False,
 *     auth_admin_user=False,
 *     nick_name="example_value",
 *     user_type="Analyst")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.QuickBI.User("example", new()
 *     {
 *         AccountName = "example_value",
 *         AdminUser = false,
 *         AuthAdminUser = false,
 *         NickName = "example_value",
 *         UserType = "Analyst",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/quickbi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quickbi.NewUser(ctx, "example", &quickbi.UserArgs{
 * 			AccountName:   pulumi.String("example_value"),
 * 			AdminUser:     pulumi.Bool(false),
 * 			AuthAdminUser: pulumi.Bool(false),
 * 			NickName:      pulumi.String("example_value"),
 * 			UserType:      pulumi.String("Analyst"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.quickbi.User;
 * import com.pulumi.alicloud.quickbi.UserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new User("example", UserArgs.builder()
 *             .accountName("example_value")
 *             .adminUser(false)
 *             .authAdminUser(false)
 *             .nickName("example_value")
 *             .userType("Analyst")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:quickbi:User
 *     properties:
 *       accountName: example_value
 *       adminUser: false
 *       authAdminUser: false
 *       nickName: example_value
 *       userType: Analyst
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Quick BI User can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:quickbi/user:User example <id>
 * ```
 */
public class User internal constructor(
    override val javaResource: com.pulumi.alicloud.quickbi.User,
) : KotlinCustomResource(javaResource, UserMapper) {
    /**
     * Alibaba Cloud account ID.
     */
    public val accountId: Output<String>?
        get() = javaResource.accountId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * An Alibaba Cloud account, Alibaba Cloud name.
     */
    public val accountName: Output<String>
        get() = javaResource.accountName().applyValue({ args0 -> args0 })

    /**
     * Whether it is the administrator. Valid values: `true` and `false`.
     */
    public val adminUser: Output<Boolean>
        get() = javaResource.adminUser().applyValue({ args0 -> args0 })

    /**
     * Whether this is a permissions administrator. Valid values: `false`, `true`.
     */
    public val authAdminUser: Output<Boolean>
        get() = javaResource.authAdminUser().applyValue({ args0 -> args0 })

    /**
     * The nickname of the user.
     */
    public val nickName: Output<String>
        get() = javaResource.nickName().applyValue({ args0 -> args0 })

    /**
     * The members of the organization of the type of role separately. Valid values: `Analyst`, `Developer` and `Visitor`.
     */
    public val userType: Output<String>
        get() = javaResource.userType().applyValue({ args0 -> args0 })
}

public object UserMapper : ResourceMapper<User> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.quickbi.User::class == javaResource::class

    override fun map(javaResource: Resource): User = User(
        javaResource as
            com.pulumi.alicloud.quickbi.User,
    )
}

/**
 * @see [User].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [User].
 */
public suspend fun user(name: String, block: suspend UserResourceBuilder.() -> Unit): User {
    val builder = UserResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [User].
 * @param name The _unique_ name of the resulting resource.
 */
public fun user(name: String): User {
    val builder = UserResourceBuilder()
    builder.name(name)
    return builder.build()
}
