@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quickbi.kotlin

import com.pulumi.alicloud.quickbi.UserArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Quick BI User resource.
 * For information about Quick BI User and how to use it, see [What is User](https://www.alibabacloud.com/help/doc-detail/33813.htm).
 * > **NOTE:** Available in v1.136.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.quickbi.User("example", {
 *     accountName: "example_value",
 *     adminUser: false,
 *     authAdminUser: false,
 *     nickName: "example_value",
 *     userType: "Analyst",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.quickbi.User("example",
 *     account_name="example_value",
 *     admin_user=False,
 *     auth_admin_user=False,
 *     nick_name="example_value",
 *     user_type="Analyst")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.QuickBI.User("example", new()
 *     {
 *         AccountName = "example_value",
 *         AdminUser = false,
 *         AuthAdminUser = false,
 *         NickName = "example_value",
 *         UserType = "Analyst",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/quickbi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quickbi.NewUser(ctx, "example", &quickbi.UserArgs{
 * 			AccountName:   pulumi.String("example_value"),
 * 			AdminUser:     pulumi.Bool(false),
 * 			AuthAdminUser: pulumi.Bool(false),
 * 			NickName:      pulumi.String("example_value"),
 * 			UserType:      pulumi.String("Analyst"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.quickbi.User;
 * import com.pulumi.alicloud.quickbi.UserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new User("example", UserArgs.builder()
 *             .accountName("example_value")
 *             .adminUser(false)
 *             .authAdminUser(false)
 *             .nickName("example_value")
 *             .userType("Analyst")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:quickbi:User
 *     properties:
 *       accountName: example_value
 *       adminUser: false
 *       authAdminUser: false
 *       nickName: example_value
 *       userType: Analyst
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Quick BI User can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:quickbi/user:User example <id>
 * ```
 * @property accountId Alibaba Cloud account ID.
 * @property accountName An Alibaba Cloud account, Alibaba Cloud name.
 * @property adminUser Whether it is the administrator. Valid values: `true` and `false`.
 * @property authAdminUser Whether this is a permissions administrator. Valid values: `false`, `true`.
 * @property nickName The nickname of the user.
 * @property userType The members of the organization of the type of role separately. Valid values: `Analyst`, `Developer` and `Visitor`.
 */
public data class UserArgs(
    public val accountId: Output<String>? = null,
    public val accountName: Output<String>? = null,
    public val adminUser: Output<Boolean>? = null,
    public val authAdminUser: Output<Boolean>? = null,
    public val nickName: Output<String>? = null,
    public val userType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.quickbi.UserArgs> {
    override fun toJava(): com.pulumi.alicloud.quickbi.UserArgs =
        com.pulumi.alicloud.quickbi.UserArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .adminUser(adminUser?.applyValue({ args0 -> args0 }))
            .authAdminUser(authAdminUser?.applyValue({ args0 -> args0 }))
            .nickName(nickName?.applyValue({ args0 -> args0 }))
            .userType(userType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserArgs].
 */
@PulumiTagMarker
public class UserArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var accountName: Output<String>? = null

    private var adminUser: Output<Boolean>? = null

    private var authAdminUser: Output<Boolean>? = null

    private var nickName: Output<String>? = null

    private var userType: Output<String>? = null

    /**
     * @param value Alibaba Cloud account ID.
     */
    @JvmName("vuqweccgpohqhpvr")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value An Alibaba Cloud account, Alibaba Cloud name.
     */
    @JvmName("gqflmtaqhlpahmja")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Whether it is the administrator. Valid values: `true` and `false`.
     */
    @JvmName("rfmrjtyhnnxaywfn")
    public suspend fun adminUser(`value`: Output<Boolean>) {
        this.adminUser = value
    }

    /**
     * @param value Whether this is a permissions administrator. Valid values: `false`, `true`.
     */
    @JvmName("qaatingqkrjbnurb")
    public suspend fun authAdminUser(`value`: Output<Boolean>) {
        this.authAdminUser = value
    }

    /**
     * @param value The nickname of the user.
     */
    @JvmName("encchsotjdcwhqie")
    public suspend fun nickName(`value`: Output<String>) {
        this.nickName = value
    }

    /**
     * @param value The members of the organization of the type of role separately. Valid values: `Analyst`, `Developer` and `Visitor`.
     */
    @JvmName("kqwgfsarcyurpfds")
    public suspend fun userType(`value`: Output<String>) {
        this.userType = value
    }

    /**
     * @param value Alibaba Cloud account ID.
     */
    @JvmName("cjwdeslftrgdjblc")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value An Alibaba Cloud account, Alibaba Cloud name.
     */
    @JvmName("avfeppwtjnppkkxy")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Whether it is the administrator. Valid values: `true` and `false`.
     */
    @JvmName("sjccluqqhfakhiio")
    public suspend fun adminUser(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminUser = mapped
    }

    /**
     * @param value Whether this is a permissions administrator. Valid values: `false`, `true`.
     */
    @JvmName("ybfbnletaqlscpdm")
    public suspend fun authAdminUser(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authAdminUser = mapped
    }

    /**
     * @param value The nickname of the user.
     */
    @JvmName("pnisrvhoppalfiqd")
    public suspend fun nickName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nickName = mapped
    }

    /**
     * @param value The members of the organization of the type of role separately. Valid values: `Analyst`, `Developer` and `Visitor`.
     */
    @JvmName("tpdcegckbxrbyygu")
    public suspend fun userType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userType = mapped
    }

    internal fun build(): UserArgs = UserArgs(
        accountId = accountId,
        accountName = accountName,
        adminUser = adminUser,
        authAdminUser = authAdminUser,
        nickName = nickName,
        userType = userType,
    )
}
