@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quickbi.kotlin.inputs

import com.pulumi.alicloud.quickbi.inputs.GetUsersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getUsers.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of User IDs.
 * @property keyword The keywords of the nicknames or usernames of the members of the organization.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetUsersPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val keyword: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.quickbi.inputs.GetUsersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.quickbi.inputs.GetUsersPlainArgs =
        com.pulumi.alicloud.quickbi.inputs.GetUsersPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .keyword(keyword?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUsersPlainArgs].
 */
@PulumiTagMarker
public class GetUsersPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var keyword: String? = null

    private var outputFile: String? = null

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("frpxprkxqfmkatrc")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of User IDs.
     */
    @JvmName("assifpdhydefxmft")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of User IDs.
     */
    @JvmName("frlgtvxdqtieovtl")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The keywords of the nicknames or usernames of the members of the organization.
     */
    @JvmName("lgaiwquelcpkybxr")
    public suspend fun keyword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyword = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("diqcjyaulfbbdwcp")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetUsersPlainArgs = GetUsersPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        keyword = keyword,
        outputFile = outputFile,
    )
}
