@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quickbi.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getUsers.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property keyword
 * @property outputFile
 * @property users
 */
public data class GetUsersResult(
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val keyword: String? = null,
    public val outputFile: String? = null,
    public val users: List<GetUsersUser>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.quickbi.outputs.GetUsersResult): GetUsersResult = GetUsersResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            keyword = javaType.keyword().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            users = javaType.users().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.quickbi.kotlin.outputs.GetUsersUser.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
