@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quickbi.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountId Alibaba Cloud account ID.
 * @property accountName An Alibaba Cloud account, Alibaba Cloud name.
 * @property adminUser Whether it is the administrator. Valid values: `true` and `false`.
 * @property authAdminUser Whether this is a permissions administrator. Valid values: `true` and `false`.
 * @property email The email of the user.
 * @property id The ID of the User.
 * @property nickName The nickname of the user.
 * @property phone The phone number of the user.
 * @property userId The ID of the User.
 * @property userType The members of the organization of the type of role separately. Valid values: `Analyst`, `Developer` and `Visitor`.
 */
public data class GetUsersUser(
    public val accountId: String,
    public val accountName: String,
    public val adminUser: Boolean,
    public val authAdminUser: Boolean,
    public val email: String,
    public val id: String,
    public val nickName: String,
    public val phone: String,
    public val userId: String,
    public val userType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.quickbi.outputs.GetUsersUser): GetUsersUser =
            GetUsersUser(
                accountId = javaType.accountId(),
                accountName = javaType.accountName(),
                adminUser = javaType.adminUser(),
                authAdminUser = javaType.authAdminUser(),
                email = javaType.email(),
                id = javaType.id(),
                nickName = javaType.nickName(),
                phone = javaType.phone(),
                userId = javaType.userId(),
                userType = javaType.userType(),
            )
    }
}
