@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin

import com.pulumi.alicloud.quotas.kotlin.outputs.ApplicationInfoDimension
import com.pulumi.alicloud.quotas.kotlin.outputs.ApplicationInfoDimension.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ApplicationInfo].
 */
@PulumiTagMarker
public class ApplicationInfoResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationInfoArgs = ApplicationInfoArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationInfoArgsBuilder.() -> Unit) {
        val builder = ApplicationInfoArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ApplicationInfo {
        val builtJavaResource = com.pulumi.alicloud.quotas.ApplicationInfo(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ApplicationInfo(builtJavaResource)
    }
}

public class ApplicationInfo internal constructor(
    override val javaResource: com.pulumi.alicloud.quotas.ApplicationInfo,
) : KotlinCustomResource(javaResource, ApplicationInfoMapper) {
    public val approveValue: Output<String>
        get() = javaResource.approveValue().applyValue({ args0 -> args0 })

    public val auditMode: Output<String>
        get() = javaResource.auditMode().applyValue({ args0 -> args0 })

    public val auditReason: Output<String>
        get() = javaResource.auditReason().applyValue({ args0 -> args0 })

    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    public val desireValue: Output<Double>
        get() = javaResource.desireValue().applyValue({ args0 -> args0 })

    public val dimensions: Output<List<ApplicationInfoDimension>>?
        get() = javaResource.dimensions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    public val effectiveTime: Output<String>?
        get() = javaResource.effectiveTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val envLanguage: Output<String>?
        get() = javaResource.envLanguage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val expireTime: Output<String>?
        get() = javaResource.expireTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val noticeType: Output<Int>
        get() = javaResource.noticeType().applyValue({ args0 -> args0 })

    public val productCode: Output<String>
        get() = javaResource.productCode().applyValue({ args0 -> args0 })

    public val quotaActionCode: Output<String>
        get() = javaResource.quotaActionCode().applyValue({ args0 -> args0 })

    public val quotaCategory: Output<String>?
        get() = javaResource.quotaCategory().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val quotaDescription: Output<String>
        get() = javaResource.quotaDescription().applyValue({ args0 -> args0 })

    public val quotaName: Output<String>
        get() = javaResource.quotaName().applyValue({ args0 -> args0 })

    public val quotaUnit: Output<String>
        get() = javaResource.quotaUnit().applyValue({ args0 -> args0 })

    public val reason: Output<String>
        get() = javaResource.reason().applyValue({ args0 -> args0 })

    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object ApplicationInfoMapper : ResourceMapper<ApplicationInfo> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.quotas.ApplicationInfo::class == javaResource::class

    override fun map(javaResource: Resource): ApplicationInfo = ApplicationInfo(
        javaResource as
            com.pulumi.alicloud.quotas.ApplicationInfo,
    )
}

/**
 * @see [ApplicationInfo].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApplicationInfo].
 */
public suspend fun applicationInfo(
    name: String,
    block: suspend ApplicationInfoResourceBuilder.() -> Unit,
): ApplicationInfo {
    val builder = ApplicationInfoResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApplicationInfo].
 * @param name The _unique_ name of the resulting resource.
 */
public fun applicationInfo(name: String): ApplicationInfo {
    val builder = ApplicationInfoResourceBuilder()
    builder.name(name)
    return builder.build()
}
