@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin

import com.pulumi.alicloud.quotas.ApplicationInfoArgs.builder
import com.pulumi.alicloud.quotas.kotlin.inputs.ApplicationInfoDimensionArgs
import com.pulumi.alicloud.quotas.kotlin.inputs.ApplicationInfoDimensionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property auditMode
 * @property desireValue
 * @property dimensions
 * @property effectiveTime
 * @property envLanguage
 * @property expireTime
 * @property noticeType
 * @property productCode
 * @property quotaActionCode
 * @property quotaCategory
 * @property reason
 */
public data class ApplicationInfoArgs(
    public val auditMode: Output<String>? = null,
    public val desireValue: Output<Double>? = null,
    public val dimensions: Output<List<ApplicationInfoDimensionArgs>>? = null,
    public val effectiveTime: Output<String>? = null,
    public val envLanguage: Output<String>? = null,
    public val expireTime: Output<String>? = null,
    public val noticeType: Output<Int>? = null,
    public val productCode: Output<String>? = null,
    public val quotaActionCode: Output<String>? = null,
    public val quotaCategory: Output<String>? = null,
    public val reason: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.quotas.ApplicationInfoArgs> {
    override fun toJava(): com.pulumi.alicloud.quotas.ApplicationInfoArgs =
        com.pulumi.alicloud.quotas.ApplicationInfoArgs.builder()
            .auditMode(auditMode?.applyValue({ args0 -> args0 }))
            .desireValue(desireValue?.applyValue({ args0 -> args0 }))
            .dimensions(
                dimensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .effectiveTime(effectiveTime?.applyValue({ args0 -> args0 }))
            .envLanguage(envLanguage?.applyValue({ args0 -> args0 }))
            .expireTime(expireTime?.applyValue({ args0 -> args0 }))
            .noticeType(noticeType?.applyValue({ args0 -> args0 }))
            .productCode(productCode?.applyValue({ args0 -> args0 }))
            .quotaActionCode(quotaActionCode?.applyValue({ args0 -> args0 }))
            .quotaCategory(quotaCategory?.applyValue({ args0 -> args0 }))
            .reason(reason?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationInfoArgs].
 */
@PulumiTagMarker
public class ApplicationInfoArgsBuilder internal constructor() {
    private var auditMode: Output<String>? = null

    private var desireValue: Output<Double>? = null

    private var dimensions: Output<List<ApplicationInfoDimensionArgs>>? = null

    private var effectiveTime: Output<String>? = null

    private var envLanguage: Output<String>? = null

    private var expireTime: Output<String>? = null

    private var noticeType: Output<Int>? = null

    private var productCode: Output<String>? = null

    private var quotaActionCode: Output<String>? = null

    private var quotaCategory: Output<String>? = null

    private var reason: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("ckgvylmvsyqpmpvy")
    public suspend fun auditMode(`value`: Output<String>) {
        this.auditMode = value
    }

    /**
     * @param value
     */
    @JvmName("cyaqblqyuegihatc")
    public suspend fun desireValue(`value`: Output<Double>) {
        this.desireValue = value
    }

    /**
     * @param value
     */
    @JvmName("ypkfnmhtyqncdysl")
    public suspend fun dimensions(`value`: Output<List<ApplicationInfoDimensionArgs>>) {
        this.dimensions = value
    }

    @JvmName("bwmfeepqmstgnkcq")
    public suspend fun dimensions(vararg values: Output<ApplicationInfoDimensionArgs>) {
        this.dimensions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("unwhtjihndoooull")
    public suspend fun dimensions(values: List<Output<ApplicationInfoDimensionArgs>>) {
        this.dimensions = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("hbunhwwjljjmttec")
    public suspend fun effectiveTime(`value`: Output<String>) {
        this.effectiveTime = value
    }

    /**
     * @param value
     */
    @JvmName("gtkmsajnecqwsptd")
    public suspend fun envLanguage(`value`: Output<String>) {
        this.envLanguage = value
    }

    /**
     * @param value
     */
    @JvmName("ogusmjewbsttoija")
    public suspend fun expireTime(`value`: Output<String>) {
        this.expireTime = value
    }

    /**
     * @param value
     */
    @JvmName("mdyeawngskvnhpfg")
    public suspend fun noticeType(`value`: Output<Int>) {
        this.noticeType = value
    }

    /**
     * @param value
     */
    @JvmName("txnubsmpgivmktma")
    public suspend fun productCode(`value`: Output<String>) {
        this.productCode = value
    }

    /**
     * @param value
     */
    @JvmName("khwkkmkvwiwmxdhi")
    public suspend fun quotaActionCode(`value`: Output<String>) {
        this.quotaActionCode = value
    }

    /**
     * @param value
     */
    @JvmName("boavqjenpgyhjaxg")
    public suspend fun quotaCategory(`value`: Output<String>) {
        this.quotaCategory = value
    }

    /**
     * @param value
     */
    @JvmName("vqyybwnamjioboun")
    public suspend fun reason(`value`: Output<String>) {
        this.reason = value
    }

    /**
     * @param value
     */
    @JvmName("effuctsmrfsgwweq")
    public suspend fun auditMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auditMode = mapped
    }

    /**
     * @param value
     */
    @JvmName("wgygslemotddrrja")
    public suspend fun desireValue(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desireValue = mapped
    }

    /**
     * @param value
     */
    @JvmName("ihvlhbdvinsqynfd")
    public suspend fun dimensions(`value`: List<ApplicationInfoDimensionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wosakxyylrjxrfye")
    public suspend fun dimensions(argument: List<suspend ApplicationInfoDimensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationInfoDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("nealywmtmhjorgkx")
    public suspend fun dimensions(vararg argument: suspend ApplicationInfoDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApplicationInfoDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("oodroqnnanipiemx")
    public suspend fun dimensions(argument: suspend ApplicationInfoDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationInfoDimensionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param values
     */
    @JvmName("bhkxbmktehltashr")
    public suspend fun dimensions(vararg values: ApplicationInfoDimensionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param value
     */
    @JvmName("ywlrynocwucfiknd")
    public suspend fun effectiveTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effectiveTime = mapped
    }

    /**
     * @param value
     */
    @JvmName("vvdtcnupwxesxkgo")
    public suspend fun envLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.envLanguage = mapped
    }

    /**
     * @param value
     */
    @JvmName("jijohdkpefaeqvvq")
    public suspend fun expireTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expireTime = mapped
    }

    /**
     * @param value
     */
    @JvmName("ibjitsfookhjepbd")
    public suspend fun noticeType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noticeType = mapped
    }

    /**
     * @param value
     */
    @JvmName("mnxkceusseeajvqn")
    public suspend fun productCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productCode = mapped
    }

    /**
     * @param value
     */
    @JvmName("etqlcxibfdeoyihg")
    public suspend fun quotaActionCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quotaActionCode = mapped
    }

    /**
     * @param value
     */
    @JvmName("qabtmeudfadwwylg")
    public suspend fun quotaCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quotaCategory = mapped
    }

    /**
     * @param value
     */
    @JvmName("cmosbcintjphcjek")
    public suspend fun reason(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reason = mapped
    }

    internal fun build(): ApplicationInfoArgs = ApplicationInfoArgs(
        auditMode = auditMode,
        desireValue = desireValue,
        dimensions = dimensions,
        effectiveTime = effectiveTime,
        envLanguage = envLanguage,
        expireTime = expireTime,
        noticeType = noticeType,
        productCode = productCode,
        quotaActionCode = quotaActionCode,
        quotaCategory = quotaCategory,
        reason = reason,
    )
}
