@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin

import com.pulumi.alicloud.quotas.kotlin.outputs.QuotaAlarmQuotaDimension
import com.pulumi.alicloud.quotas.kotlin.outputs.QuotaAlarmQuotaDimension.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [QuotaAlarm].
 */
@PulumiTagMarker
public class QuotaAlarmResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: QuotaAlarmArgs = QuotaAlarmArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend QuotaAlarmArgsBuilder.() -> Unit) {
        val builder = QuotaAlarmArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): QuotaAlarm {
        val builtJavaResource = com.pulumi.alicloud.quotas.QuotaAlarm(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return QuotaAlarm(builtJavaResource)
    }
}

/**
 * Provides a Quotas Quota Alarm resource.
 * For information about Quotas Quota Alarm and how to use it, see [What is Quota Alarm](https://www.alibabacloud.com/help/en/quota-center/developer-reference/api-quotas-2020-05-10-createquotaalarm).
 * > **NOTE:** Available since v1.116.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultQuotaAlarm = new alicloud.quotas.QuotaAlarm("default", {
 *     quotaActionCode: "q_desktop-count",
 *     quotaDimensions: [{
 *         key: "regionId",
 *         value: "cn-hangzhou",
 *     }],
 *     thresholdPercent: 80,
 *     productCode: "gws",
 *     quotaAlarmName: `${name}-${_default.result}`,
 *     thresholdType: "used",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_quota_alarm = alicloud.quotas.QuotaAlarm("default",
 *     quota_action_code="q_desktop-count",
 *     quota_dimensions=[{
 *         "key": "regionId",
 *         "value": "cn-hangzhou",
 *     }],
 *     threshold_percent=80,
 *     product_code="gws",
 *     quota_alarm_name=f"{name}-{default['result']}",
 *     threshold_type="used")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultQuotaAlarm = new AliCloud.Quotas.QuotaAlarm("default", new()
 *     {
 *         QuotaActionCode = "q_desktop-count",
 *         QuotaDimensions = new[]
 *         {
 *             new AliCloud.Quotas.Inputs.QuotaAlarmQuotaDimensionArgs
 *             {
 *                 Key = "regionId",
 *                 Value = "cn-hangzhou",
 *             },
 *         },
 *         ThresholdPercent = 80,
 *         ProductCode = "gws",
 *         QuotaAlarmName = $"{name}-{@default.Result}",
 *         ThresholdType = "used",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/quotas"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = quotas.NewQuotaAlarm(ctx, "default", &quotas.QuotaAlarmArgs{
 * 			QuotaActionCode: pulumi.String("q_desktop-count"),
 * 			QuotaDimensions: quotas.QuotaAlarmQuotaDimensionArray{
 * 				&quotas.QuotaAlarmQuotaDimensionArgs{
 * 					Key:   pulumi.String("regionId"),
 * 					Value: pulumi.String("cn-hangzhou"),
 * 				},
 * 			},
 * 			ThresholdPercent: pulumi.Float64(80),
 * 			ProductCode:      pulumi.String("gws"),
 * 			QuotaAlarmName:   pulumi.Sprintf("%v-%v", name, _default.Result),
 * 			ThresholdType:    pulumi.String("used"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.quotas.QuotaAlarm;
 * import com.pulumi.alicloud.quotas.QuotaAlarmArgs;
 * import com.pulumi.alicloud.quotas.inputs.QuotaAlarmQuotaDimensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultQuotaAlarm = new QuotaAlarm("defaultQuotaAlarm", QuotaAlarmArgs.builder()
 *             .quotaActionCode("q_desktop-count")
 *             .quotaDimensions(QuotaAlarmQuotaDimensionArgs.builder()
 *                 .key("regionId")
 *                 .value("cn-hangzhou")
 *                 .build())
 *             .thresholdPercent(80)
 *             .productCode("gws")
 *             .quotaAlarmName(String.format("%s-%s", name,default_.result()))
 *             .thresholdType("used")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultQuotaAlarm:
 *     type: alicloud:quotas:QuotaAlarm
 *     name: default
 *     properties:
 *       quotaActionCode: q_desktop-count
 *       quotaDimensions:
 *         - key: regionId
 *           value: cn-hangzhou
 *       thresholdPercent: 80
 *       productCode: gws
 *       quotaAlarmName: ${name}-${default.result}
 *       thresholdType: used
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Quotas Quota Alarm can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:quotas/quotaAlarm:QuotaAlarm example <id>
 * ```
 */
public class QuotaAlarm internal constructor(
    override val javaResource: com.pulumi.alicloud.quotas.QuotaAlarm,
) : KotlinCustomResource(javaResource, QuotaAlarmMapper) {
    /**
     * The creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The Product Code.
     */
    public val productCode: Output<String>
        get() = javaResource.productCode().applyValue({ args0 -> args0 })

    /**
     * The Quota Action Code.
     */
    public val quotaActionCode: Output<String>
        get() = javaResource.quotaActionCode().applyValue({ args0 -> args0 })

    /**
     * The name of Quota Alarm.
     */
    public val quotaAlarmName: Output<String>
        get() = javaResource.quotaAlarmName().applyValue({ args0 -> args0 })

    /**
     * The Quota Dimensions. See `quota_dimensions` below.
     */
    public val quotaDimensions: Output<List<QuotaAlarmQuotaDimension>>?
        get() = javaResource.quotaDimensions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The threshold of Quota Alarm.
     */
    public val threshold: Output<Double>?
        get() = javaResource.threshold().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The threshold percent of Quota Alarm.
     */
    public val thresholdPercent: Output<Double>?
        get() = javaResource.thresholdPercent().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Quota alarm type. Value:
     * - used: Quota used alarm.
     * - usable: alarm for the remaining available quota.
     */
    public val thresholdType: Output<String>
        get() = javaResource.thresholdType().applyValue({ args0 -> args0 })

    /**
     * The WebHook of Quota Alarm.
     */
    public val webHook: Output<String>?
        get() = javaResource.webHook().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object QuotaAlarmMapper : ResourceMapper<QuotaAlarm> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.quotas.QuotaAlarm::class == javaResource::class

    override fun map(javaResource: Resource): QuotaAlarm = QuotaAlarm(
        javaResource as
            com.pulumi.alicloud.quotas.QuotaAlarm,
    )
}

/**
 * @see [QuotaAlarm].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [QuotaAlarm].
 */
public suspend fun quotaAlarm(name: String, block: suspend QuotaAlarmResourceBuilder.() -> Unit): QuotaAlarm {
    val builder = QuotaAlarmResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [QuotaAlarm].
 * @param name The _unique_ name of the resulting resource.
 */
public fun quotaAlarm(name: String): QuotaAlarm {
    val builder = QuotaAlarmResourceBuilder()
    builder.name(name)
    return builder.build()
}
