@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin

import com.pulumi.alicloud.quotas.QuotaAlarmArgs.builder
import com.pulumi.alicloud.quotas.kotlin.inputs.QuotaAlarmQuotaDimensionArgs
import com.pulumi.alicloud.quotas.kotlin.inputs.QuotaAlarmQuotaDimensionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Quotas Quota Alarm resource.
 * For information about Quotas Quota Alarm and how to use it, see [What is Quota Alarm](https://www.alibabacloud.com/help/en/quota-center/developer-reference/api-quotas-2020-05-10-createquotaalarm).
 * > **NOTE:** Available since v1.116.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultQuotaAlarm = new alicloud.quotas.QuotaAlarm("default", {
 *     quotaActionCode: "q_desktop-count",
 *     quotaDimensions: [{
 *         key: "regionId",
 *         value: "cn-hangzhou",
 *     }],
 *     thresholdPercent: 80,
 *     productCode: "gws",
 *     quotaAlarmName: `${name}-${_default.result}`,
 *     thresholdType: "used",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_quota_alarm = alicloud.quotas.QuotaAlarm("default",
 *     quota_action_code="q_desktop-count",
 *     quota_dimensions=[{
 *         "key": "regionId",
 *         "value": "cn-hangzhou",
 *     }],
 *     threshold_percent=80,
 *     product_code="gws",
 *     quota_alarm_name=f"{name}-{default['result']}",
 *     threshold_type="used")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultQuotaAlarm = new AliCloud.Quotas.QuotaAlarm("default", new()
 *     {
 *         QuotaActionCode = "q_desktop-count",
 *         QuotaDimensions = new[]
 *         {
 *             new AliCloud.Quotas.Inputs.QuotaAlarmQuotaDimensionArgs
 *             {
 *                 Key = "regionId",
 *                 Value = "cn-hangzhou",
 *             },
 *         },
 *         ThresholdPercent = 80,
 *         ProductCode = "gws",
 *         QuotaAlarmName = $"{name}-{@default.Result}",
 *         ThresholdType = "used",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/quotas"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = quotas.NewQuotaAlarm(ctx, "default", &quotas.QuotaAlarmArgs{
 * 			QuotaActionCode: pulumi.String("q_desktop-count"),
 * 			QuotaDimensions: quotas.QuotaAlarmQuotaDimensionArray{
 * 				&quotas.QuotaAlarmQuotaDimensionArgs{
 * 					Key:   pulumi.String("regionId"),
 * 					Value: pulumi.String("cn-hangzhou"),
 * 				},
 * 			},
 * 			ThresholdPercent: pulumi.Float64(80),
 * 			ProductCode:      pulumi.String("gws"),
 * 			QuotaAlarmName:   pulumi.Sprintf("%v-%v", name, _default.Result),
 * 			ThresholdType:    pulumi.String("used"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.quotas.QuotaAlarm;
 * import com.pulumi.alicloud.quotas.QuotaAlarmArgs;
 * import com.pulumi.alicloud.quotas.inputs.QuotaAlarmQuotaDimensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultQuotaAlarm = new QuotaAlarm("defaultQuotaAlarm", QuotaAlarmArgs.builder()
 *             .quotaActionCode("q_desktop-count")
 *             .quotaDimensions(QuotaAlarmQuotaDimensionArgs.builder()
 *                 .key("regionId")
 *                 .value("cn-hangzhou")
 *                 .build())
 *             .thresholdPercent(80)
 *             .productCode("gws")
 *             .quotaAlarmName(String.format("%s-%s", name,default_.result()))
 *             .thresholdType("used")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultQuotaAlarm:
 *     type: alicloud:quotas:QuotaAlarm
 *     name: default
 *     properties:
 *       quotaActionCode: q_desktop-count
 *       quotaDimensions:
 *         - key: regionId
 *           value: cn-hangzhou
 *       thresholdPercent: 80
 *       productCode: gws
 *       quotaAlarmName: ${name}-${default.result}
 *       thresholdType: used
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Quotas Quota Alarm can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:quotas/quotaAlarm:QuotaAlarm example <id>
 * ```
 * @property productCode The Product Code.
 * @property quotaActionCode The Quota Action Code.
 * @property quotaAlarmName The name of Quota Alarm.
 * @property quotaDimensions The Quota Dimensions. See `quota_dimensions` below.
 * @property threshold The threshold of Quota Alarm.
 * @property thresholdPercent The threshold percent of Quota Alarm.
 * @property thresholdType Quota alarm type. Value:
 * - used: Quota used alarm.
 * - usable: alarm for the remaining available quota.
 * @property webHook The WebHook of Quota Alarm.
 */
public data class QuotaAlarmArgs(
    public val productCode: Output<String>? = null,
    public val quotaActionCode: Output<String>? = null,
    public val quotaAlarmName: Output<String>? = null,
    public val quotaDimensions: Output<List<QuotaAlarmQuotaDimensionArgs>>? = null,
    public val threshold: Output<Double>? = null,
    public val thresholdPercent: Output<Double>? = null,
    public val thresholdType: Output<String>? = null,
    public val webHook: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.quotas.QuotaAlarmArgs> {
    override fun toJava(): com.pulumi.alicloud.quotas.QuotaAlarmArgs =
        com.pulumi.alicloud.quotas.QuotaAlarmArgs.builder()
            .productCode(productCode?.applyValue({ args0 -> args0 }))
            .quotaActionCode(quotaActionCode?.applyValue({ args0 -> args0 }))
            .quotaAlarmName(quotaAlarmName?.applyValue({ args0 -> args0 }))
            .quotaDimensions(
                quotaDimensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .threshold(threshold?.applyValue({ args0 -> args0 }))
            .thresholdPercent(thresholdPercent?.applyValue({ args0 -> args0 }))
            .thresholdType(thresholdType?.applyValue({ args0 -> args0 }))
            .webHook(webHook?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QuotaAlarmArgs].
 */
@PulumiTagMarker
public class QuotaAlarmArgsBuilder internal constructor() {
    private var productCode: Output<String>? = null

    private var quotaActionCode: Output<String>? = null

    private var quotaAlarmName: Output<String>? = null

    private var quotaDimensions: Output<List<QuotaAlarmQuotaDimensionArgs>>? = null

    private var threshold: Output<Double>? = null

    private var thresholdPercent: Output<Double>? = null

    private var thresholdType: Output<String>? = null

    private var webHook: Output<String>? = null

    /**
     * @param value The Product Code.
     */
    @JvmName("yqhlmlicnvqueywq")
    public suspend fun productCode(`value`: Output<String>) {
        this.productCode = value
    }

    /**
     * @param value The Quota Action Code.
     */
    @JvmName("pjoeusefxwxxmcrg")
    public suspend fun quotaActionCode(`value`: Output<String>) {
        this.quotaActionCode = value
    }

    /**
     * @param value The name of Quota Alarm.
     */
    @JvmName("cqcxjptuvapaaync")
    public suspend fun quotaAlarmName(`value`: Output<String>) {
        this.quotaAlarmName = value
    }

    /**
     * @param value The Quota Dimensions. See `quota_dimensions` below.
     */
    @JvmName("bhmdhfciiheyvcat")
    public suspend fun quotaDimensions(`value`: Output<List<QuotaAlarmQuotaDimensionArgs>>) {
        this.quotaDimensions = value
    }

    @JvmName("upkiltvnlhdunuef")
    public suspend fun quotaDimensions(vararg values: Output<QuotaAlarmQuotaDimensionArgs>) {
        this.quotaDimensions = Output.all(values.asList())
    }

    /**
     * @param values The Quota Dimensions. See `quota_dimensions` below.
     */
    @JvmName("qveqelqfuhpgiqvp")
    public suspend fun quotaDimensions(values: List<Output<QuotaAlarmQuotaDimensionArgs>>) {
        this.quotaDimensions = Output.all(values)
    }

    /**
     * @param value The threshold of Quota Alarm.
     */
    @JvmName("ixvrgfuaoaaltlmf")
    public suspend fun threshold(`value`: Output<Double>) {
        this.threshold = value
    }

    /**
     * @param value The threshold percent of Quota Alarm.
     */
    @JvmName("eiuvkwetrnfiermx")
    public suspend fun thresholdPercent(`value`: Output<Double>) {
        this.thresholdPercent = value
    }

    /**
     * @param value Quota alarm type. Value:
     * - used: Quota used alarm.
     * - usable: alarm for the remaining available quota.
     */
    @JvmName("yjlrcqqhkypqcpre")
    public suspend fun thresholdType(`value`: Output<String>) {
        this.thresholdType = value
    }

    /**
     * @param value The WebHook of Quota Alarm.
     */
    @JvmName("ldeveqdmvcavwbpo")
    public suspend fun webHook(`value`: Output<String>) {
        this.webHook = value
    }

    /**
     * @param value The Product Code.
     */
    @JvmName("uunbcourwsgpyhue")
    public suspend fun productCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productCode = mapped
    }

    /**
     * @param value The Quota Action Code.
     */
    @JvmName("qnjkuygvhfnuoptb")
    public suspend fun quotaActionCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quotaActionCode = mapped
    }

    /**
     * @param value The name of Quota Alarm.
     */
    @JvmName("ybgfuumgdtapopvv")
    public suspend fun quotaAlarmName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quotaAlarmName = mapped
    }

    /**
     * @param value The Quota Dimensions. See `quota_dimensions` below.
     */
    @JvmName("nmcaymcdetcxlsqk")
    public suspend fun quotaDimensions(`value`: List<QuotaAlarmQuotaDimensionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quotaDimensions = mapped
    }

    /**
     * @param argument The Quota Dimensions. See `quota_dimensions` below.
     */
    @JvmName("oyrhobbcvicrebgk")
    public suspend fun quotaDimensions(argument: List<suspend QuotaAlarmQuotaDimensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            QuotaAlarmQuotaDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.quotaDimensions = mapped
    }

    /**
     * @param argument The Quota Dimensions. See `quota_dimensions` below.
     */
    @JvmName("husddqgworijjduw")
    public suspend fun quotaDimensions(vararg argument: suspend QuotaAlarmQuotaDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            QuotaAlarmQuotaDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.quotaDimensions = mapped
    }

    /**
     * @param argument The Quota Dimensions. See `quota_dimensions` below.
     */
    @JvmName("uhkcltnnfdiwthif")
    public suspend fun quotaDimensions(argument: suspend QuotaAlarmQuotaDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            QuotaAlarmQuotaDimensionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.quotaDimensions = mapped
    }

    /**
     * @param values The Quota Dimensions. See `quota_dimensions` below.
     */
    @JvmName("qhglbitfkwuihjub")
    public suspend fun quotaDimensions(vararg values: QuotaAlarmQuotaDimensionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.quotaDimensions = mapped
    }

    /**
     * @param value The threshold of Quota Alarm.
     */
    @JvmName("rfpgioycsvnpgvnr")
    public suspend fun threshold(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threshold = mapped
    }

    /**
     * @param value The threshold percent of Quota Alarm.
     */
    @JvmName("kutksqbewcfnrced")
    public suspend fun thresholdPercent(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thresholdPercent = mapped
    }

    /**
     * @param value Quota alarm type. Value:
     * - used: Quota used alarm.
     * - usable: alarm for the remaining available quota.
     */
    @JvmName("nyoeexgwketaoigo")
    public suspend fun thresholdType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thresholdType = mapped
    }

    /**
     * @param value The WebHook of Quota Alarm.
     */
    @JvmName("kfajbhtjcvhqaojd")
    public suspend fun webHook(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webHook = mapped
    }

    internal fun build(): QuotaAlarmArgs = QuotaAlarmArgs(
        productCode = productCode,
        quotaActionCode = quotaActionCode,
        quotaAlarmName = quotaAlarmName,
        quotaDimensions = quotaDimensions,
        threshold = threshold,
        thresholdPercent = thresholdPercent,
        thresholdType = thresholdType,
        webHook = webHook,
    )
}
