@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin

import com.pulumi.alicloud.quotas.kotlin.outputs.QuotaApplicationDimension
import com.pulumi.alicloud.quotas.kotlin.outputs.QuotaApplicationDimension.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [QuotaApplication].
 */
@PulumiTagMarker
public class QuotaApplicationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: QuotaApplicationArgs = QuotaApplicationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend QuotaApplicationArgsBuilder.() -> Unit) {
        val builder = QuotaApplicationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): QuotaApplication {
        val builtJavaResource = com.pulumi.alicloud.quotas.QuotaApplication(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return QuotaApplication(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * Quotas Quota Application can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:quotas/quotaApplication:QuotaApplication example <id>
 * ```
 */
public class QuotaApplication internal constructor(
    override val javaResource: com.pulumi.alicloud.quotas.QuotaApplication,
) : KotlinCustomResource(javaResource, QuotaApplicationMapper) {
    /**
     * The approve value of the quota application.
     */
    public val approveValue: Output<String>
        get() = javaResource.approveValue().applyValue({ args0 -> args0 })

    /**
     * Quota audit mode. Value:
     * - Sync: Synchronize auditing. The quota center automatically approves, and the approval result is returned immediately, but the probability of application passing is lower than that of asynchronous approval, and the validity period of the increase quota is 1 hour.
     * - Async: Asynchronous auditing. Manual review, the probability of application passing is relatively high, and the validity period of the increase quota is 1 month.
     * > **NOTE:**  This parameter takes effect only for the ECS specification quota of the cloud server.
     */
    public val auditMode: Output<String>
        get() = javaResource.auditMode().applyValue({ args0 -> args0 })

    /**
     * The audit reason.
     */
    public val auditReason: Output<String>
        get() = javaResource.auditReason().applyValue({ args0 -> args0 })

    /**
     * Resource attribute field representing creation time.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The desire value of the quota application.
     */
    public val desireValue: Output<Double>
        get() = javaResource.desireValue().applyValue({ args0 -> args0 })

    /**
     * QuotaDimensions. See `dimensions` below.
     */
    public val dimensions: Output<List<QuotaApplicationDimension>>?
        get() = javaResource.dimensions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The effective time of the quota application.
     */
    public val effectiveTime: Output<String>?
        get() = javaResource.effectiveTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The language of the quota alert notification. Value:
     * - zh (default): Chinese.
     * - en: English.
     */
    public val envLanguage: Output<String>?
        get() = javaResource.envLanguage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The expired time of the quota application.
     */
    public val expireTime: Output<String>?
        get() = javaResource.expireTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to send a notification about the application result. Valid values:0: sends a notification about the application result.3: A notification about the application result is sent.
     */
    public val noticeType: Output<Int>
        get() = javaResource.noticeType().applyValue({ args0 -> args0 })

    /**
     * The product code.
     */
    public val productCode: Output<String>
        get() = javaResource.productCode().applyValue({ args0 -> args0 })

    /**
     * The ID of quota action.
     */
    public val quotaActionCode: Output<String>
        get() = javaResource.quotaActionCode().applyValue({ args0 -> args0 })

    /**
     * The quota type.
     * - CommonQuota (default): Generic quota.
     * - FlowControl:API rate quota.
     * - WhiteListLabel: Equity quota.
     */
    public val quotaCategory: Output<String>?
        get() = javaResource.quotaCategory().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the quota application.
     */
    public val quotaDescription: Output<String>
        get() = javaResource.quotaDescription().applyValue({ args0 -> args0 })

    /**
     * The name of the quota application.
     */
    public val quotaName: Output<String>
        get() = javaResource.quotaName().applyValue({ args0 -> args0 })

    /**
     * The unit of the quota application.
     */
    public val quotaUnit: Output<String>
        get() = javaResource.quotaUnit().applyValue({ args0 -> args0 })

    /**
     * The reason of the quota application.
     */
    public val reason: Output<String>
        get() = javaResource.reason().applyValue({ args0 -> args0 })

    /**
     * Application Status:
     * - Disagree: reject.
     * - Agree: Approved.
     * - Process: under review.
     * - Cancel: Closed.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object QuotaApplicationMapper : ResourceMapper<QuotaApplication> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.quotas.QuotaApplication::class == javaResource::class

    override fun map(javaResource: Resource): QuotaApplication = QuotaApplication(
        javaResource as
            com.pulumi.alicloud.quotas.QuotaApplication,
    )
}

/**
 * @see [QuotaApplication].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [QuotaApplication].
 */
public suspend fun quotaApplication(
    name: String,
    block: suspend QuotaApplicationResourceBuilder.() -> Unit,
): QuotaApplication {
    val builder = QuotaApplicationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [QuotaApplication].
 * @param name The _unique_ name of the resulting resource.
 */
public fun quotaApplication(name: String): QuotaApplication {
    val builder = QuotaApplicationResourceBuilder()
    builder.name(name)
    return builder.build()
}
