@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin

import com.pulumi.alicloud.quotas.QuotaApplicationArgs.builder
import com.pulumi.alicloud.quotas.kotlin.inputs.QuotaApplicationDimensionArgs
import com.pulumi.alicloud.quotas.kotlin.inputs.QuotaApplicationDimensionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * Quotas Quota Application can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:quotas/quotaApplication:QuotaApplication example <id>
 * ```
 * @property auditMode Quota audit mode. Value:
 * - Sync: Synchronize auditing. The quota center automatically approves, and the approval result is returned immediately, but the probability of application passing is lower than that of asynchronous approval, and the validity period of the increase quota is 1 hour.
 * - Async: Asynchronous auditing. Manual review, the probability of application passing is relatively high, and the validity period of the increase quota is 1 month.
 * > **NOTE:**  This parameter takes effect only for the ECS specification quota of the cloud server.
 * @property desireValue The desire value of the quota application.
 * @property dimensions QuotaDimensions. See `dimensions` below.
 * @property effectiveTime The effective time of the quota application.
 * @property envLanguage The language of the quota alert notification. Value:
 * - zh (default): Chinese.
 * - en: English.
 * @property expireTime The expired time of the quota application.
 * @property noticeType Specifies whether to send a notification about the application result. Valid values:0: sends a notification about the application result.3: A notification about the application result is sent.
 * @property productCode The product code.
 * @property quotaActionCode The ID of quota action.
 * @property quotaCategory The quota type.
 * - CommonQuota (default): Generic quota.
 * - FlowControl:API rate quota.
 * - WhiteListLabel: Equity quota.
 * @property reason The reason of the quota application.
 */
public data class QuotaApplicationArgs(
    public val auditMode: Output<String>? = null,
    public val desireValue: Output<Double>? = null,
    public val dimensions: Output<List<QuotaApplicationDimensionArgs>>? = null,
    public val effectiveTime: Output<String>? = null,
    public val envLanguage: Output<String>? = null,
    public val expireTime: Output<String>? = null,
    public val noticeType: Output<Int>? = null,
    public val productCode: Output<String>? = null,
    public val quotaActionCode: Output<String>? = null,
    public val quotaCategory: Output<String>? = null,
    public val reason: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.quotas.QuotaApplicationArgs> {
    override fun toJava(): com.pulumi.alicloud.quotas.QuotaApplicationArgs =
        com.pulumi.alicloud.quotas.QuotaApplicationArgs.builder()
            .auditMode(auditMode?.applyValue({ args0 -> args0 }))
            .desireValue(desireValue?.applyValue({ args0 -> args0 }))
            .dimensions(
                dimensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .effectiveTime(effectiveTime?.applyValue({ args0 -> args0 }))
            .envLanguage(envLanguage?.applyValue({ args0 -> args0 }))
            .expireTime(expireTime?.applyValue({ args0 -> args0 }))
            .noticeType(noticeType?.applyValue({ args0 -> args0 }))
            .productCode(productCode?.applyValue({ args0 -> args0 }))
            .quotaActionCode(quotaActionCode?.applyValue({ args0 -> args0 }))
            .quotaCategory(quotaCategory?.applyValue({ args0 -> args0 }))
            .reason(reason?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QuotaApplicationArgs].
 */
@PulumiTagMarker
public class QuotaApplicationArgsBuilder internal constructor() {
    private var auditMode: Output<String>? = null

    private var desireValue: Output<Double>? = null

    private var dimensions: Output<List<QuotaApplicationDimensionArgs>>? = null

    private var effectiveTime: Output<String>? = null

    private var envLanguage: Output<String>? = null

    private var expireTime: Output<String>? = null

    private var noticeType: Output<Int>? = null

    private var productCode: Output<String>? = null

    private var quotaActionCode: Output<String>? = null

    private var quotaCategory: Output<String>? = null

    private var reason: Output<String>? = null

    /**
     * @param value Quota audit mode. Value:
     * - Sync: Synchronize auditing. The quota center automatically approves, and the approval result is returned immediately, but the probability of application passing is lower than that of asynchronous approval, and the validity period of the increase quota is 1 hour.
     * - Async: Asynchronous auditing. Manual review, the probability of application passing is relatively high, and the validity period of the increase quota is 1 month.
     * > **NOTE:**  This parameter takes effect only for the ECS specification quota of the cloud server.
     */
    @JvmName("mwhhcegebmynckli")
    public suspend fun auditMode(`value`: Output<String>) {
        this.auditMode = value
    }

    /**
     * @param value The desire value of the quota application.
     */
    @JvmName("jkxvhbhopxmruhrq")
    public suspend fun desireValue(`value`: Output<Double>) {
        this.desireValue = value
    }

    /**
     * @param value QuotaDimensions. See `dimensions` below.
     */
    @JvmName("fauanhenrovrgpfm")
    public suspend fun dimensions(`value`: Output<List<QuotaApplicationDimensionArgs>>) {
        this.dimensions = value
    }

    @JvmName("chywhnyuiwiqkaxu")
    public suspend fun dimensions(vararg values: Output<QuotaApplicationDimensionArgs>) {
        this.dimensions = Output.all(values.asList())
    }

    /**
     * @param values QuotaDimensions. See `dimensions` below.
     */
    @JvmName("yjxersxngklnwtjd")
    public suspend fun dimensions(values: List<Output<QuotaApplicationDimensionArgs>>) {
        this.dimensions = Output.all(values)
    }

    /**
     * @param value The effective time of the quota application.
     */
    @JvmName("fdecbyfnosrjpcbw")
    public suspend fun effectiveTime(`value`: Output<String>) {
        this.effectiveTime = value
    }

    /**
     * @param value The language of the quota alert notification. Value:
     * - zh (default): Chinese.
     * - en: English.
     */
    @JvmName("wxxtnrcgsaigskdm")
    public suspend fun envLanguage(`value`: Output<String>) {
        this.envLanguage = value
    }

    /**
     * @param value The expired time of the quota application.
     */
    @JvmName("dwdxlkuvrsrrofgt")
    public suspend fun expireTime(`value`: Output<String>) {
        this.expireTime = value
    }

    /**
     * @param value Specifies whether to send a notification about the application result. Valid values:0: sends a notification about the application result.3: A notification about the application result is sent.
     */
    @JvmName("rkxdfwxwlfvybyps")
    public suspend fun noticeType(`value`: Output<Int>) {
        this.noticeType = value
    }

    /**
     * @param value The product code.
     */
    @JvmName("gvsfisvhhkvfbpks")
    public suspend fun productCode(`value`: Output<String>) {
        this.productCode = value
    }

    /**
     * @param value The ID of quota action.
     */
    @JvmName("utmhylkswlgsiddl")
    public suspend fun quotaActionCode(`value`: Output<String>) {
        this.quotaActionCode = value
    }

    /**
     * @param value The quota type.
     * - CommonQuota (default): Generic quota.
     * - FlowControl:API rate quota.
     * - WhiteListLabel: Equity quota.
     */
    @JvmName("wqkohlitclfxwnxj")
    public suspend fun quotaCategory(`value`: Output<String>) {
        this.quotaCategory = value
    }

    /**
     * @param value The reason of the quota application.
     */
    @JvmName("eyqxhmbogjbcpdcj")
    public suspend fun reason(`value`: Output<String>) {
        this.reason = value
    }

    /**
     * @param value Quota audit mode. Value:
     * - Sync: Synchronize auditing. The quota center automatically approves, and the approval result is returned immediately, but the probability of application passing is lower than that of asynchronous approval, and the validity period of the increase quota is 1 hour.
     * - Async: Asynchronous auditing. Manual review, the probability of application passing is relatively high, and the validity period of the increase quota is 1 month.
     * > **NOTE:**  This parameter takes effect only for the ECS specification quota of the cloud server.
     */
    @JvmName("saighnuhnqoecrpq")
    public suspend fun auditMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auditMode = mapped
    }

    /**
     * @param value The desire value of the quota application.
     */
    @JvmName("ojkpokojkbqlyrrt")
    public suspend fun desireValue(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desireValue = mapped
    }

    /**
     * @param value QuotaDimensions. See `dimensions` below.
     */
    @JvmName("ijuwkeakofccklei")
    public suspend fun dimensions(`value`: List<QuotaApplicationDimensionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param argument QuotaDimensions. See `dimensions` below.
     */
    @JvmName("mvipxuchjxisexek")
    public suspend fun dimensions(argument: List<suspend QuotaApplicationDimensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            QuotaApplicationDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument QuotaDimensions. See `dimensions` below.
     */
    @JvmName("etqeqkqmydkhefnn")
    public suspend fun dimensions(vararg argument: suspend QuotaApplicationDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            QuotaApplicationDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument QuotaDimensions. See `dimensions` below.
     */
    @JvmName("yyegcqicikewapyd")
    public suspend fun dimensions(argument: suspend QuotaApplicationDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            QuotaApplicationDimensionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param values QuotaDimensions. See `dimensions` below.
     */
    @JvmName("lcvdkshwybmpnexd")
    public suspend fun dimensions(vararg values: QuotaApplicationDimensionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param value The effective time of the quota application.
     */
    @JvmName("nviehjnwsygiejqo")
    public suspend fun effectiveTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effectiveTime = mapped
    }

    /**
     * @param value The language of the quota alert notification. Value:
     * - zh (default): Chinese.
     * - en: English.
     */
    @JvmName("syqamyifsrfoxbnw")
    public suspend fun envLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.envLanguage = mapped
    }

    /**
     * @param value The expired time of the quota application.
     */
    @JvmName("wmfsawvgrcvgxbya")
    public suspend fun expireTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expireTime = mapped
    }

    /**
     * @param value Specifies whether to send a notification about the application result. Valid values:0: sends a notification about the application result.3: A notification about the application result is sent.
     */
    @JvmName("wkbbjybymgofsqvf")
    public suspend fun noticeType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noticeType = mapped
    }

    /**
     * @param value The product code.
     */
    @JvmName("mtnymatcclfwdjyl")
    public suspend fun productCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productCode = mapped
    }

    /**
     * @param value The ID of quota action.
     */
    @JvmName("mmnnqhkruffoxhkp")
    public suspend fun quotaActionCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quotaActionCode = mapped
    }

    /**
     * @param value The quota type.
     * - CommonQuota (default): Generic quota.
     * - FlowControl:API rate quota.
     * - WhiteListLabel: Equity quota.
     */
    @JvmName("gbhdxfnmwvmolspy")
    public suspend fun quotaCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quotaCategory = mapped
    }

    /**
     * @param value The reason of the quota application.
     */
    @JvmName("ctiqswyckrnitohw")
    public suspend fun reason(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reason = mapped
    }

    internal fun build(): QuotaApplicationArgs = QuotaApplicationArgs(
        auditMode = auditMode,
        desireValue = desireValue,
        dimensions = dimensions,
        effectiveTime = effectiveTime,
        envLanguage = envLanguage,
        expireTime = expireTime,
        noticeType = noticeType,
        productCode = productCode,
        quotaActionCode = quotaActionCode,
        quotaCategory = quotaCategory,
        reason = reason,
    )
}
