@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin

import com.pulumi.alicloud.quotas.QuotasFunctions.getApplicationInfosPlain
import com.pulumi.alicloud.quotas.QuotasFunctions.getQuotaAlarmsPlain
import com.pulumi.alicloud.quotas.QuotasFunctions.getQuotaApplicationsPlain
import com.pulumi.alicloud.quotas.QuotasFunctions.getQuotasPlain
import com.pulumi.alicloud.quotas.QuotasFunctions.getTemplateApplicationsPlain
import com.pulumi.alicloud.quotas.kotlin.inputs.GetApplicationInfosDimension
import com.pulumi.alicloud.quotas.kotlin.inputs.GetApplicationInfosPlainArgs
import com.pulumi.alicloud.quotas.kotlin.inputs.GetApplicationInfosPlainArgsBuilder
import com.pulumi.alicloud.quotas.kotlin.inputs.GetQuotaAlarmsPlainArgs
import com.pulumi.alicloud.quotas.kotlin.inputs.GetQuotaAlarmsPlainArgsBuilder
import com.pulumi.alicloud.quotas.kotlin.inputs.GetQuotaAlarmsQuotaDimension
import com.pulumi.alicloud.quotas.kotlin.inputs.GetQuotaApplicationsDimension
import com.pulumi.alicloud.quotas.kotlin.inputs.GetQuotaApplicationsPlainArgs
import com.pulumi.alicloud.quotas.kotlin.inputs.GetQuotaApplicationsPlainArgsBuilder
import com.pulumi.alicloud.quotas.kotlin.inputs.GetQuotasDimension
import com.pulumi.alicloud.quotas.kotlin.inputs.GetQuotasPlainArgs
import com.pulumi.alicloud.quotas.kotlin.inputs.GetQuotasPlainArgsBuilder
import com.pulumi.alicloud.quotas.kotlin.inputs.GetTemplateApplicationsPlainArgs
import com.pulumi.alicloud.quotas.kotlin.inputs.GetTemplateApplicationsPlainArgsBuilder
import com.pulumi.alicloud.quotas.kotlin.outputs.GetApplicationInfosResult
import com.pulumi.alicloud.quotas.kotlin.outputs.GetQuotaAlarmsResult
import com.pulumi.alicloud.quotas.kotlin.outputs.GetQuotaApplicationsResult
import com.pulumi.alicloud.quotas.kotlin.outputs.GetQuotasResult
import com.pulumi.alicloud.quotas.kotlin.outputs.GetTemplateApplicationsResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.quotas.kotlin.outputs.GetApplicationInfosResult.Companion.toKotlin as getApplicationInfosResultToKotlin
import com.pulumi.alicloud.quotas.kotlin.outputs.GetQuotaAlarmsResult.Companion.toKotlin as getQuotaAlarmsResultToKotlin
import com.pulumi.alicloud.quotas.kotlin.outputs.GetQuotaApplicationsResult.Companion.toKotlin as getQuotaApplicationsResultToKotlin
import com.pulumi.alicloud.quotas.kotlin.outputs.GetQuotasResult.Companion.toKotlin as getQuotasResultToKotlin
import com.pulumi.alicloud.quotas.kotlin.outputs.GetTemplateApplicationsResult.Companion.toKotlin as getTemplateApplicationsResultToKotlin

public object QuotasFunctions {
    /**
     *
     * @param argument A collection of arguments for invoking getApplicationInfos.
     * @return A collection of values returned by getApplicationInfos.
     */
    public suspend fun getApplicationInfos(argument: GetApplicationInfosPlainArgs): GetApplicationInfosResult =
        getApplicationInfosResultToKotlin(getApplicationInfosPlain(argument.toJava()).await())

    /**
     * @see [getApplicationInfos].
     * @param dimensions
     * @param enableDetails
     * @param ids
     * @param keyWord
     * @param outputFile
     * @param productCode
     * @param quotaActionCode
     * @param quotaCategory
     * @param status
     * @return A collection of values returned by getApplicationInfos.
     */
    public suspend fun getApplicationInfos(
        dimensions: List<GetApplicationInfosDimension>? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        keyWord: String? = null,
        outputFile: String? = null,
        productCode: String,
        quotaActionCode: String? = null,
        quotaCategory: String? = null,
        status: String? = null,
    ): GetApplicationInfosResult {
        val argument = GetApplicationInfosPlainArgs(
            dimensions = dimensions,
            enableDetails = enableDetails,
            ids = ids,
            keyWord = keyWord,
            outputFile = outputFile,
            productCode = productCode,
            quotaActionCode = quotaActionCode,
            quotaCategory = quotaCategory,
            status = status,
        )
        return getApplicationInfosResultToKotlin(getApplicationInfosPlain(argument.toJava()).await())
    }

    /**
     * @see [getApplicationInfos].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;quotas&#46;kotlin&#46;inputs&#46;GetApplicationInfosPlainArgs].
     * @return A collection of values returned by getApplicationInfos.
     */
    public suspend fun getApplicationInfos(argument: suspend GetApplicationInfosPlainArgsBuilder.() -> Unit): GetApplicationInfosResult {
        val builder = GetApplicationInfosPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplicationInfosResultToKotlin(getApplicationInfosPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Quotas Quota Alarms of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.116.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.quotas.getQuotaAlarms({
     *     ids: ["5VR90-421F886-81E9-xxx"],
     *     nameRegex: "tf-testAcc",
     * });
     * export const firstQuotasQuotaAlarmId = example.then(example => example.alarms?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.quotas.get_quota_alarms(ids=["5VR90-421F886-81E9-xxx"],
     *     name_regex="tf-testAcc")
     * pulumi.export("firstQuotasQuotaAlarmId", example.alarms[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Quotas.GetQuotaAlarms.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "5VR90-421F886-81E9-xxx",
     *         },
     *         NameRegex = "tf-testAcc",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstQuotasQuotaAlarmId"] = example&#46;Apply(getQuotaAlarmsResult => getQuotaAlarmsResult&#46;Alarms[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/quotas"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := quotas.GetQuotaAlarms(ctx, &quotas.GetQuotaAlarmsArgs{
     * 			Ids: []string{
     * 				"5VR90-421F886-81E9-xxx",
     * 			},
     * 			NameRegex: pulumi.StringRef("tf-testAcc"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstQuotasQuotaAlarmId", example.Alarms[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.quotas.QuotasFunctions;
     * import com.pulumi.alicloud.quotas.inputs.GetQuotaAlarmsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = QuotasFunctions.getQuotaAlarms(GetQuotaAlarmsArgs.builder()
     *             .ids("5VR90-421F886-81E9-xxx")
     *             .nameRegex("tf-testAcc")
     *             .build());
     *         ctx.export("firstQuotasQuotaAlarmId", example.applyValue(getQuotaAlarmsResult -> getQuotaAlarmsResult.alarms()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:quotas:getQuotaAlarms
     *       Arguments:
     *         ids:
     *           - 5VR90-421F886-81E9-xxx
     *         nameRegex: tf-testAcc
     * outputs:
     *   firstQuotasQuotaAlarmId: ${example.alarms[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getQuotaAlarms.
     * @return A collection of values returned by getQuotaAlarms.
     */
    public suspend fun getQuotaAlarms(argument: GetQuotaAlarmsPlainArgs): GetQuotaAlarmsResult =
        getQuotaAlarmsResultToKotlin(getQuotaAlarmsPlain(argument.toJava()).await())

    /**
     * @see [getQuotaAlarms].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Quota Alarm IDs.
     * @param nameRegex A regex string to filter results by Quota Alarm name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param productCode The Product Code.
     * @param quotaActionCode The Quota Action Code.
     * @param quotaAlarmName The name of Quota Alarm.
     * @param quotaDimensions The Quota Dimensions.
     * @return A collection of values returned by getQuotaAlarms.
     */
    public suspend fun getQuotaAlarms(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        productCode: String? = null,
        quotaActionCode: String? = null,
        quotaAlarmName: String? = null,
        quotaDimensions: List<GetQuotaAlarmsQuotaDimension>? = null,
    ): GetQuotaAlarmsResult {
        val argument = GetQuotaAlarmsPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            productCode = productCode,
            quotaActionCode = quotaActionCode,
            quotaAlarmName = quotaAlarmName,
            quotaDimensions = quotaDimensions,
        )
        return getQuotaAlarmsResultToKotlin(getQuotaAlarmsPlain(argument.toJava()).await())
    }

    /**
     * @see [getQuotaAlarms].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;quotas&#46;kotlin&#46;inputs&#46;GetQuotaAlarmsPlainArgs].
     * @return A collection of values returned by getQuotaAlarms.
     */
    public suspend fun getQuotaAlarms(argument: suspend GetQuotaAlarmsPlainArgsBuilder.() -> Unit): GetQuotaAlarmsResult {
        val builder = GetQuotaAlarmsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getQuotaAlarmsResultToKotlin(getQuotaAlarmsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Quotas Quota Applications of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.117.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const defaultQuotaApplication = new alicloud.quotas.QuotaApplication("default", {
     *     productCode: "vpc",
     *     noticeType: 3,
     *     effectiveTime: "2023-05-22T16:00:00Z",
     *     expireTime: "2024-09-15T00:08:32Z",
     *     desireValue: 1,
     *     reason: "",
     *     quotaActionCode: "vpc_whitelist/ha_vip_whitelist",
     *     auditMode: "Sync",
     *     envLanguage: "zh",
     *     quotaCategory: "WhiteListLabel",
     * });
     * const default = pulumi.all([defaultQuotaApplication&#46;quotaCategory, defaultQuotaApplication&#46;id])&#46;apply(([quotaCategory, id]) => alicloud.quotas.getQuotaApplicationsOutput({
     *     productCode: "vpc",
     *     enableDetails: true,
     *     quotaCategory: quotaCategory,
     *     ids: [id],
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default_quota_application = alicloud.quotas.QuotaApplication("default",
     *     product_code="vpc",
     *     notice_type=3,
     *     effective_time="2023-05-22T16:00:00Z",
     *     expire_time="2024-09-15T00:08:32Z",
     *     desire_value=1,
     *     reason="",
     *     quota_action_code="vpc_whitelist/ha_vip_whitelist",
     *     audit_mode="Sync",
     *     env_language="zh",
     *     quota_category="WhiteListLabel")
     * default = pulumi.Output.all(
     *     quota_category=default_quota_application.quota_category,
     *     id=default_quota_application.id
     * ).apply(lambda resolved_outputs: alicloud.quotas.get_quota_applications_output(product_code="vpc",
     *     enable_details=True,
     *     quota_category=resolved_outputs['quota_category'],
     *     ids=[resolved_outputs['id']]))
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var defaultQuotaApplication = new AliCloud.Quotas.QuotaApplication("default", new()
     *     {
     *         ProductCode = "vpc",
     *         NoticeType = 3,
     *         EffectiveTime = "2023-05-22T16:00:00Z",
     *         ExpireTime = "2024-09-15T00:08:32Z",
     *         DesireValue = 1,
     *         Reason = "",
     *         QuotaActionCode = "vpc_whitelist/ha_vip_whitelist",
     *         AuditMode = "Sync",
     *         EnvLanguage = "zh",
     *         QuotaCategory = "WhiteListLabel",
     *     });
     *     var @default = AliCloud.Quotas.GetQuotaApplications.Invoke(new()
     *     {
     *         ProductCode = "vpc",
     *         EnableDetails = true,
     *         QuotaCategory = defaultQuotaApplication.QuotaCategory,
     *         Ids = new[]
     *         {
     *             defaultQuotaApplication.Id,
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/quotas"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		defaultQuotaApplication, err := quotas.NewQuotaApplication(ctx, "default", &quotas.QuotaApplicationArgs{
     * 			ProductCode:     pulumi.String("vpc"),
     * 			NoticeType:      pulumi.Int(3),
     * 			EffectiveTime:   pulumi.String("2023-05-22T16:00:00Z"),
     * 			ExpireTime:      pulumi.String("2024-09-15T00:08:32Z"),
     * 			DesireValue:     pulumi.Float64(1),
     * 			Reason:          pulumi.String(""),
     * 			QuotaActionCode: pulumi.String("vpc_whitelist/ha_vip_whitelist"),
     * 			AuditMode:       pulumi.String("Sync"),
     * 			EnvLanguage:     pulumi.String("zh"),
     * 			QuotaCategory:   pulumi.String("WhiteListLabel"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_ = pulumi.All(defaultQuotaApplication.QuotaCategory, defaultQuotaApplication.ID()).ApplyT(func(_args []interface{}) (quotas.GetQuotaApplicationsResult, error) {
     * 			quotaCategory := _args[0].(*string)
     * 			id := _args[1].(string)
     * 			return quotas.GetQuotaApplicationsResult(interface{}(quotas.GetQuotaApplicationsOutput(ctx, quotas.GetQuotaApplicationsOutputArgs{
     * 				ProductCode:   "vpc",
     * 				EnableDetails: true,
     * 				QuotaCategory: quotaCategory,
     * 				Ids: []string{
     * 					id,
     * 				},
     * 			}, nil))), nil
     * 		}).(quotas.GetQuotaApplicationsResultOutput)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.quotas.QuotaApplication;
     * import com.pulumi.alicloud.quotas.QuotaApplicationArgs;
     * import com.pulumi.alicloud.quotas.QuotasFunctions;
     * import com.pulumi.alicloud.quotas.inputs.GetQuotaApplicationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var defaultQuotaApplication = new QuotaApplication("defaultQuotaApplication", QuotaApplicationArgs.builder()
     *             .productCode("vpc")
     *             .noticeType("3")
     *             .effectiveTime("2023-05-22T16:00:00Z")
     *             .expireTime("2024-09-15T00:08:32Z")
     *             .desireValue("1")
     *             .reason("")
     *             .quotaActionCode("vpc_whitelist/ha_vip_whitelist")
     *             .auditMode("Sync")
     *             .envLanguage("zh")
     *             .quotaCategory("WhiteListLabel")
     *             .build());
     *         final var default = QuotasFunctions.getQuotaApplications(GetQuotaApplicationsArgs.builder()
     *             .productCode("vpc")
     *             .enableDetails("true")
     *             .quotaCategory(defaultQuotaApplication.quotaCategory())
     *             .ids(defaultQuotaApplication.id())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   defaultQuotaApplication:
     *     type: alicloud:quotas:QuotaApplication
     *     name: default
     *     properties:
     *       productCode: vpc
     *       noticeType: '3'
     *       effectiveTime: 2023-05-22T16:00:00Z
     *       expireTime: 2024-09-15T00:08:32Z
     *       desireValue: '1'
     *       reason:
     *       quotaActionCode: vpc_whitelist/ha_vip_whitelist
     *       auditMode: Sync
     *       envLanguage: zh
     *       quotaCategory: WhiteListLabel
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:quotas:getQuotaApplications
     *       Arguments:
     *         productCode: vpc
     *         enableDetails: 'true'
     *         quotaCategory: ${defaultQuotaApplication.quotaCategory}
     *         ids:
     *           - ${defaultQuotaApplication.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getQuotaApplications.
     * @return A collection of values returned by getQuotaApplications.
     */
    public suspend fun getQuotaApplications(argument: GetQuotaApplicationsPlainArgs): GetQuotaApplicationsResult =
        getQuotaApplicationsResultToKotlin(getQuotaApplicationsPlain(argument.toJava()).await())

    /**
     * @see [getQuotaApplications].
     * @param dimensions The quota dimensions.
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Application Info IDs.
     * @param keyWord
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param productCode The product code.
     * @param quotaActionCode The ID of quota action.
     * @param quotaCategory The quota category. Valid values: `CommonQuota`, `FlowControl`, `WhiteListLabel`.
     * @param status The status of the quota application. Valid Values: `Agree`, `Disagree` and `Process`.
     * @return A collection of values returned by getQuotaApplications.
     */
    public suspend fun getQuotaApplications(
        dimensions: List<GetQuotaApplicationsDimension>? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        keyWord: String? = null,
        outputFile: String? = null,
        productCode: String,
        quotaActionCode: String? = null,
        quotaCategory: String? = null,
        status: String? = null,
    ): GetQuotaApplicationsResult {
        val argument = GetQuotaApplicationsPlainArgs(
            dimensions = dimensions,
            enableDetails = enableDetails,
            ids = ids,
            keyWord = keyWord,
            outputFile = outputFile,
            productCode = productCode,
            quotaActionCode = quotaActionCode,
            quotaCategory = quotaCategory,
            status = status,
        )
        return getQuotaApplicationsResultToKotlin(getQuotaApplicationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getQuotaApplications].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;quotas&#46;kotlin&#46;inputs&#46;GetQuotaApplicationsPlainArgs].
     * @return A collection of values returned by getQuotaApplications.
     */
    public suspend fun getQuotaApplications(argument: suspend GetQuotaApplicationsPlainArgsBuilder.() -> Unit): GetQuotaApplicationsResult {
        val builder = GetQuotaApplicationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getQuotaApplicationsResultToKotlin(getQuotaApplicationsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Quotas Quotas of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.115.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.quotas.getQuotas({
     *     productCode: "ecs",
     *     nameRegex: "专有宿主机总数量上限",
     * });
     * export const firstQuotasQuotaId = example.then(example => example.quotas?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.quotas.get_quotas(product_code="ecs",
     *     name_regex="专有宿主机总数量上限")
     * pulumi.export("firstQuotasQuotaId", example.quotas[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Quotas.GetQuotas.Invoke(new()
     *     {
     *         ProductCode = "ecs",
     *         NameRegex = "专有宿主机总数量上限",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstQuotasQuotaId"] = example&#46;Apply(getQuotasResult => getQuotasResult&#46;Quotas[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/quotas"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := quotas.GetQuotas(ctx, &quotas.GetQuotasArgs{
     * 			ProductCode: "ecs",
     * 			NameRegex:   pulumi.StringRef("专有宿主机总数量上限"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstQuotasQuotaId", example.Quotas[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.quotas.QuotasFunctions;
     * import com.pulumi.alicloud.quotas.inputs.GetQuotasArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = QuotasFunctions.getQuotas(GetQuotasArgs.builder()
     *             .productCode("ecs")
     *             .nameRegex("专有宿主机总数量上限")
     *             .build());
     *         ctx.export("firstQuotasQuotaId", example.applyValue(getQuotasResult -> getQuotasResult.quotas()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:quotas:getQuotas
     *       Arguments:
     *         productCode: ecs
     *         nameRegex: 专有宿主机总数量上限
     * outputs:
     *   firstQuotasQuotaId: ${example.quotas[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getQuotas.
     * @return A collection of values returned by getQuotas.
     */
    public suspend fun getQuotas(argument: GetQuotasPlainArgs): GetQuotasResult =
        getQuotasResultToKotlin(getQuotasPlain(argument.toJava()).await())

    /**
     * @see [getQuotas].
     * @param dimensions The dimensions.
     * @param groupCode The group code.
     * @param keyWord The key word.
     * @param nameRegex A regex string to filter results by Quota name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param productCode The product code.
     * @param quotaActionCode The quota action code.
     * @param quotaCategory The category of quota. Valid Values: `FlowControl` and `CommonQuota`, `WhiteListLabel`.
     * @param sortField Cloud service ECS specification quota supports setting sorting fields. Valid Values: `TIME`, `TOTAL` and `RESERVED`.
     * @param sortOrder Ranking of cloud service ECS specification quota support. Valid Values: `Ascending` and `Descending`.
     * @return A collection of values returned by getQuotas.
     */
    public suspend fun getQuotas(
        dimensions: List<GetQuotasDimension>? = null,
        groupCode: String? = null,
        keyWord: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        productCode: String,
        quotaActionCode: String? = null,
        quotaCategory: String? = null,
        sortField: String? = null,
        sortOrder: String? = null,
    ): GetQuotasResult {
        val argument = GetQuotasPlainArgs(
            dimensions = dimensions,
            groupCode = groupCode,
            keyWord = keyWord,
            nameRegex = nameRegex,
            outputFile = outputFile,
            productCode = productCode,
            quotaActionCode = quotaActionCode,
            quotaCategory = quotaCategory,
            sortField = sortField,
            sortOrder = sortOrder,
        )
        return getQuotasResultToKotlin(getQuotasPlain(argument.toJava()).await())
    }

    /**
     * @see [getQuotas].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;quotas&#46;kotlin&#46;inputs&#46;GetQuotasPlainArgs].
     * @return A collection of values returned by getQuotas.
     */
    public suspend fun getQuotas(argument: suspend GetQuotasPlainArgsBuilder.() -> Unit): GetQuotasResult {
        val builder = GetQuotasPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getQuotasResultToKotlin(getQuotasPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Quotas Template Applications available to the user.[What is Template Applications](https://www.alibabacloud.com/help/en/quota-center/developer-reference/api-quotas-2020-05-10-createquotaapplicationsfortemplate)
     * > **NOTE:** Available since v1.214.0.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.resourcemanager.getAccounts({
     *     status: "CreateSuccess",
     * });
     * const defaultTemplateApplications = new alicloud.quotas.TemplateApplications("default", {
     *     quotaActionCode: "vpc_whitelist/ha_vip_whitelist",
     *     productCode: "vpc",
     *     quotaCategory: "FlowControl",
     *     aliyunUids: [_default&#46;then(_default => _default&#46;ids?&#46;[0])],
     *     desireValue: 6,
     *     noticeType: 0,
     *     envLanguage: "zh",
     *     reason: "example",
     *     dimensions: [
     *         {
     *             key: "apiName",
     *             value: "GetProductQuotaDimension",
     *         },
     *         {
     *             key: "apiVersion",
     *             value: "2020-05-10",
     *         },
     *         {
     *             key: "regionId",
     *             value: "cn-hangzhou",
     *         },
     *     ],
     * });
     * const defaultGetTemplateApplications = alicloud.quotas.getTemplateApplicationsOutput({
     *     ids: [defaultTemplateApplications&#46;id],
     *     productCode: "vpc",
     *     quotaActionCode: "vpc_whitelist/ha_vip_whitelist",
     *     quotaCategory: "FlowControl",
     * });
     * export const alicloudQuotasTemplateApplicationsExampleId = defaultGetTemplateApplications.apply(defaultGetTemplateApplications => defaultGetTemplateApplications.applications?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.resourcemanager.get_accounts(status="CreateSuccess")
     * default_template_applications = alicloud.quotas.TemplateApplications("default",
     *     quota_action_code="vpc_whitelist/ha_vip_whitelist",
     *     product_code="vpc",
     *     quota_category="FlowControl",
     *     aliyun_uids=[default&#46;ids[0]],
     *     desire_value=6,
     *     notice_type=0,
     *     env_language="zh",
     *     reason="example",
     *     dimensions=[
     *         {
     *             "key": "apiName",
     *             "value": "GetProductQuotaDimension",
     *         },
     *         {
     *             "key": "apiVersion",
     *             "value": "2020-05-10",
     *         },
     *         {
     *             "key": "regionId",
     *             "value": "cn-hangzhou",
     *         },
     *     ])
     * default_get_template_applications = alicloud.quotas.get_template_applications_output(ids=[default_template_applications&#46;id],
     *     product_code="vpc",
     *     quota_action_code="vpc_whitelist/ha_vip_whitelist",
     *     quota_category="FlowControl")
     * pulumi.export("alicloudQuotasTemplateApplicationsExampleId", default_get_template_applications.applications[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.ResourceManager.GetAccounts.Invoke(new()
     *     {
     *         Status = "CreateSuccess",
     *     });
     *     var defaultTemplateApplications = new AliCloud.Quotas.TemplateApplications("default", new()
     *     {
     *         QuotaActionCode = "vpc_whitelist/ha_vip_whitelist",
     *         ProductCode = "vpc",
     *         QuotaCategory = "FlowControl",
     *         AliyunUids = new[]
     *         {
     *             @default.Apply(@default => @default.Apply(getAccountsResult => getAccountsResult.Ids[0])),
     *         },
     *         DesireValue = 6,
     *         NoticeType = 0,
     *         EnvLanguage = "zh",
     *         Reason = "example",
     *         Dimensions = new[]
     *         {
     *             new AliCloud.Quotas.Inputs.TemplateApplicationsDimensionArgs
     *             {
     *                 Key = "apiName",
     *                 Value = "GetProductQuotaDimension",
     *             },
     *             new AliCloud.Quotas.Inputs.TemplateApplicationsDimensionArgs
     *             {
     *                 Key = "apiVersion",
     *                 Value = "2020-05-10",
     *             },
     *             new AliCloud.Quotas.Inputs.TemplateApplicationsDimensionArgs
     *             {
     *                 Key = "regionId",
     *                 Value = "cn-hangzhou",
     *             },
     *         },
     *     });
     *     var defaultGetTemplateApplications = AliCloud.Quotas.GetTemplateApplications.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultTemplateApplications.Id,
     *         },
     *         ProductCode = "vpc",
     *         QuotaActionCode = "vpc_whitelist/ha_vip_whitelist",
     *         QuotaCategory = "FlowControl",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudQuotasTemplateApplicationsExampleId"] = defaultGetTemplateApplications&#46;Apply(getTemplateApplicationsResult => getTemplateApplicationsResult&#46;Applications[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/quotas"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := resourcemanager.GetAccounts(ctx, &resourcemanager.GetAccountsArgs{
     * 			Status: pulumi.StringRef("CreateSuccess"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultTemplateApplications, err := quotas.NewTemplateApplications(ctx, "default", &quotas.TemplateApplicationsArgs{
     * 			QuotaActionCode: pulumi.String("vpc_whitelist/ha_vip_whitelist"),
     * 			ProductCode:     pulumi.String("vpc"),
     * 			QuotaCategory:   pulumi.String("FlowControl"),
     * 			AliyunUids: pulumi.StringArray{
     * 				pulumi.String(_default.Ids[0]),
     * 			},
     * 			DesireValue: pulumi.Float64(6),
     * 			NoticeType:  pulumi.Int(0),
     * 			EnvLanguage: pulumi.String("zh"),
     * 			Reason:      pulumi.String("example"),
     * 			Dimensions: quotas.TemplateApplicationsDimensionArray{
     * 				&quotas.TemplateApplicationsDimensionArgs{
     * 					Key:   pulumi.String("apiName"),
     * 					Value: pulumi.String("GetProductQuotaDimension"),
     * 				},
     * 				&quotas.TemplateApplicationsDimensionArgs{
     * 					Key:   pulumi.String("apiVersion"),
     * 					Value: pulumi.String("2020-05-10"),
     * 				},
     * 				&quotas.TemplateApplicationsDimensionArgs{
     * 					Key:   pulumi.String("regionId"),
     * 					Value: pulumi.String("cn-hangzhou"),
     * 				},
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultGetTemplateApplications := quotas.LookupTemplateApplicationsOutput(ctx, quotas.GetTemplateApplicationsOutputArgs{
     * 			Ids: pulumi.StringArray{
     * 				defaultTemplateApplications.ID(),
     * 			},
     * 			ProductCode:     pulumi.String("vpc"),
     * 			QuotaActionCode: pulumi.String("vpc_whitelist/ha_vip_whitelist"),
     * 			QuotaCategory:   pulumi.String("FlowControl"),
     * 		}, nil)
     * 		ctx.Export("alicloudQuotasTemplateApplicationsExampleId", defaultGetTemplateApplications.ApplyT(func(defaultGetTemplateApplications quotas.GetTemplateApplicationsResult) (*string, error) {
     * 			return &defaultGetTemplateApplications.Applications[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
     * import com.pulumi.alicloud.resourcemanager.inputs.GetAccountsArgs;
     * import com.pulumi.alicloud.quotas.TemplateApplications;
     * import com.pulumi.alicloud.quotas.TemplateApplicationsArgs;
     * import com.pulumi.alicloud.quotas.inputs.TemplateApplicationsDimensionArgs;
     * import com.pulumi.alicloud.quotas.QuotasFunctions;
     * import com.pulumi.alicloud.quotas.inputs.GetTemplateApplicationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = ResourcemanagerFunctions.getAccounts(GetAccountsArgs.builder()
     *             .status("CreateSuccess")
     *             .build());
     *         var defaultTemplateApplications = new TemplateApplications("defaultTemplateApplications", TemplateApplicationsArgs.builder()
     *             .quotaActionCode("vpc_whitelist/ha_vip_whitelist")
     *             .productCode("vpc")
     *             .quotaCategory("FlowControl")
     *             .aliyunUids(default_.ids()[0])
     *             .desireValue(6)
     *             .noticeType("0")
     *             .envLanguage("zh")
     *             .reason("example")
     *             .dimensions(
     *                 TemplateApplicationsDimensionArgs.builder()
     *                     .key("apiName")
     *                     .value("GetProductQuotaDimension")
     *                     .build(),
     *                 TemplateApplicationsDimensionArgs.builder()
     *                     .key("apiVersion")
     *                     .value("2020-05-10")
     *                     .build(),
     *                 TemplateApplicationsDimensionArgs.builder()
     *                     .key("regionId")
     *                     .value("cn-hangzhou")
     *                     .build())
     *             .build());
     *         final var defaultGetTemplateApplications = QuotasFunctions.getTemplateApplications(GetTemplateApplicationsArgs.builder()
     *             .ids(defaultTemplateApplications.id())
     *             .productCode("vpc")
     *             .quotaActionCode("vpc_whitelist/ha_vip_whitelist")
     *             .quotaCategory("FlowControl")
     *             .build());
     *         ctx.export("alicloudQuotasTemplateApplicationsExampleId", defaultGetTemplateApplications.applyValue(getTemplateApplicationsResult -> getTemplateApplicationsResult).applyValue(defaultGetTemplateApplications -> defaultGetTemplateApplications.applyValue(getTemplateApplicationsResult -> getTemplateApplicationsResult.applications()[0].id())));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   defaultTemplateApplications:
     *     type: alicloud:quotas:TemplateApplications
     *     name: default
     *     properties:
     *       quotaActionCode: vpc_whitelist/ha_vip_whitelist
     *       productCode: vpc
     *       quotaCategory: FlowControl
     *       aliyunUids:
     *         - ${default.ids[0]}
     *       desireValue: 6
     *       noticeType: '0'
     *       envLanguage: zh
     *       reason: example
     *       dimensions:
     *         - key: apiName
     *           value: GetProductQuotaDimension
     *         - key: apiVersion
     *           value: 2020-05-10
     *         - key: regionId
     *           value: cn-hangzhou
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:resourcemanager:getAccounts
     *       Arguments:
     *         status: CreateSuccess
     *   defaultGetTemplateApplications:
     *     fn::invoke:
     *       Function: alicloud:quotas:getTemplateApplications
     *       Arguments:
     *         ids:
     *           - ${defaultTemplateApplications.id}
     *         productCode: vpc
     *         quotaActionCode: vpc_whitelist/ha_vip_whitelist
     *         quotaCategory: FlowControl
     * outputs:
     *   alicloudQuotasTemplateApplicationsExampleId: ${defaultGetTemplateApplications.applications[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTemplateApplications.
     * @return A collection of values returned by getTemplateApplications.
     */
    public suspend fun getTemplateApplications(argument: GetTemplateApplicationsPlainArgs): GetTemplateApplicationsResult =
        getTemplateApplicationsResultToKotlin(getTemplateApplicationsPlain(argument.toJava()).await())

    /**
     * @see [getTemplateApplications].
     * @param batchQuotaApplicationId The ID of the quota application batch.
     * @param ids A list of Template Applications IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param productCode Cloud service name abbreviation.> For more information about cloud services that support quota centers, see Cloud services that support quota centers.
     * @param quotaActionCode The quota ID.
     * @param quotaCategory The quota type. Value: `CommonQuota`, `FlowControl` and `WhiteListLabel`.
     * @return A collection of values returned by getTemplateApplications.
     */
    public suspend fun getTemplateApplications(
        batchQuotaApplicationId: String? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        productCode: String? = null,
        quotaActionCode: String? = null,
        quotaCategory: String? = null,
    ): GetTemplateApplicationsResult {
        val argument = GetTemplateApplicationsPlainArgs(
            batchQuotaApplicationId = batchQuotaApplicationId,
            ids = ids,
            outputFile = outputFile,
            productCode = productCode,
            quotaActionCode = quotaActionCode,
            quotaCategory = quotaCategory,
        )
        return getTemplateApplicationsResultToKotlin(getTemplateApplicationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getTemplateApplications].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;quotas&#46;kotlin&#46;inputs&#46;GetTemplateApplicationsPlainArgs].
     * @return A collection of values returned by getTemplateApplications.
     */
    public suspend fun getTemplateApplications(argument: suspend GetTemplateApplicationsPlainArgsBuilder.() -> Unit): GetTemplateApplicationsResult {
        val builder = GetTemplateApplicationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTemplateApplicationsResultToKotlin(getTemplateApplicationsPlain(builtArgument.toJava()).await())
    }
}
