@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin

import com.pulumi.alicloud.quotas.kotlin.outputs.TemplateApplicationsDimension
import com.pulumi.alicloud.quotas.kotlin.outputs.TemplateApplicationsQuotaApplicationDetail
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.quotas.kotlin.outputs.TemplateApplicationsDimension.Companion.toKotlin as templateApplicationsDimensionToKotlin
import com.pulumi.alicloud.quotas.kotlin.outputs.TemplateApplicationsQuotaApplicationDetail.Companion.toKotlin as templateApplicationsQuotaApplicationDetailToKotlin

/**
 * Builder for [TemplateApplications].
 */
@PulumiTagMarker
public class TemplateApplicationsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TemplateApplicationsArgs = TemplateApplicationsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TemplateApplicationsArgsBuilder.() -> Unit) {
        val builder = TemplateApplicationsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TemplateApplications {
        val builtJavaResource = com.pulumi.alicloud.quotas.TemplateApplications(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TemplateApplications(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * Quotas Template Applications can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:quotas/templateApplications:TemplateApplications example <id>
 * ```
 */
public class TemplateApplications internal constructor(
    override val javaResource: com.pulumi.alicloud.quotas.TemplateApplications,
) : KotlinCustomResource(javaResource, TemplateApplicationsMapper) {
    /**
     * The list of Alibaba Cloud accounts (primary accounts) of the resource directory members to which the quota is applied.
     * > **NOTE:**  Only 50 members can apply for quota increase in batch at a time. For more information about the members of the resource directory, see Query the list of all members in the resource directory.
     */
    public val aliyunUids: Output<List<String>>
        get() = javaResource.aliyunUids().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The value of the quota request.
     * > **NOTE:**  The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
     */
    public val desireValue: Output<Double>
        get() = javaResource.desireValue().applyValue({ args0 -> args0 })

    /**
     * Quota dimension. See `dimensions` below.
     */
    public val dimensions: Output<List<TemplateApplicationsDimension>>?
        get() = javaResource.dimensions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> templateApplicationsDimensionToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The UTC time when the quota takes effect. This parameter applies only to the equity quota (WhiteListLabel).
     * > **NOTE:**  If the current account does not select the effective time, the default is the submission time.
     */
    public val effectiveTime: Output<String>?
        get() = javaResource.effectiveTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The language of the quota application result notification. Value:
     * - zh (default): Chinese.
     * - en: English.
     */
    public val envLanguage: Output<String>?
        get() = javaResource.envLanguage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The UTC time when the quota expires. This parameter applies only to the equity quota (WhiteListLabel).
     * > **NOTE:**  If No Expiration Time is selected for the current account, the expiration time is 99 years from the effective time of the current quota.
     */
    public val expireTime: Output<String>?
        get() = javaResource.expireTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to send notification of quota application result. Value:
     * - 0 (default): No.
     * - 3: Yes.
     */
    public val noticeType: Output<Int>?
        get() = javaResource.noticeType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Cloud service name abbreviation.
     * > **NOTE:**  For more information about cloud services that support quota centers, see Cloud services that support quota centers.
     */
    public val productCode: Output<String>
        get() = javaResource.productCode().applyValue({ args0 -> args0 })

    /**
     * The quota ID.
     */
    public val quotaActionCode: Output<String>
        get() = javaResource.quotaActionCode().applyValue({ args0 -> args0 })

    /**
     * List of quota application details.
     */
    public val quotaApplicationDetails: Output<List<TemplateApplicationsQuotaApplicationDetail>>
        get() = javaResource.quotaApplicationDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> templateApplicationsQuotaApplicationDetailToKotlin(args0) })
            })
        })

    /**
     * The quota type. Value:
     * - CommonQuota (default): Generic quota.
     * - FlowControl:API rate quota.
     * - WhiteListLabel: Equity quota.
     */
    public val quotaCategory: Output<String>
        get() = javaResource.quotaCategory().applyValue({ args0 -> args0 })

    /**
     * Reason for quota application.
     * > **NOTE:**  The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
     */
    public val reason: Output<String>
        get() = javaResource.reason().applyValue({ args0 -> args0 })
}

public object TemplateApplicationsMapper : ResourceMapper<TemplateApplications> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.quotas.TemplateApplications::class == javaResource::class

    override fun map(javaResource: Resource): TemplateApplications = TemplateApplications(
        javaResource
            as com.pulumi.alicloud.quotas.TemplateApplications,
    )
}

/**
 * @see [TemplateApplications].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TemplateApplications].
 */
public suspend fun templateApplications(
    name: String,
    block: suspend TemplateApplicationsResourceBuilder.() -> Unit,
): TemplateApplications {
    val builder = TemplateApplicationsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TemplateApplications].
 * @param name The _unique_ name of the resulting resource.
 */
public fun templateApplications(name: String): TemplateApplications {
    val builder = TemplateApplicationsResourceBuilder()
    builder.name(name)
    return builder.build()
}
