@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin

import com.pulumi.alicloud.quotas.TemplateApplicationsArgs.builder
import com.pulumi.alicloud.quotas.kotlin.inputs.TemplateApplicationsDimensionArgs
import com.pulumi.alicloud.quotas.kotlin.inputs.TemplateApplicationsDimensionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * Quotas Template Applications can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:quotas/templateApplications:TemplateApplications example <id>
 * ```
 * @property aliyunUids The list of Alibaba Cloud accounts (primary accounts) of the resource directory members to which the quota is applied.
 * > **NOTE:**  Only 50 members can apply for quota increase in batch at a time. For more information about the members of the resource directory, see Query the list of all members in the resource directory.
 * @property desireValue The value of the quota request.
 * > **NOTE:**  The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
 * @property dimensions Quota dimension. See `dimensions` below.
 * @property effectiveTime The UTC time when the quota takes effect. This parameter applies only to the equity quota (WhiteListLabel).
 * > **NOTE:**  If the current account does not select the effective time, the default is the submission time.
 * @property envLanguage The language of the quota application result notification. Value:
 * - zh (default): Chinese.
 * - en: English.
 * @property expireTime The UTC time when the quota expires. This parameter applies only to the equity quota (WhiteListLabel).
 * > **NOTE:**  If No Expiration Time is selected for the current account, the expiration time is 99 years from the effective time of the current quota.
 * @property noticeType Whether to send notification of quota application result. Value:
 * - 0 (default): No.
 * - 3: Yes.
 * @property productCode Cloud service name abbreviation.
 * > **NOTE:**  For more information about cloud services that support quota centers, see Cloud services that support quota centers.
 * @property quotaActionCode The quota ID.
 * @property quotaCategory The quota type. Value:
 * - CommonQuota (default): Generic quota.
 * - FlowControl:API rate quota.
 * - WhiteListLabel: Equity quota.
 * @property reason Reason for quota application.
 * > **NOTE:**  The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
 */
public data class TemplateApplicationsArgs(
    public val aliyunUids: Output<List<String>>? = null,
    public val desireValue: Output<Double>? = null,
    public val dimensions: Output<List<TemplateApplicationsDimensionArgs>>? = null,
    public val effectiveTime: Output<String>? = null,
    public val envLanguage: Output<String>? = null,
    public val expireTime: Output<String>? = null,
    public val noticeType: Output<Int>? = null,
    public val productCode: Output<String>? = null,
    public val quotaActionCode: Output<String>? = null,
    public val quotaCategory: Output<String>? = null,
    public val reason: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.quotas.TemplateApplicationsArgs> {
    override fun toJava(): com.pulumi.alicloud.quotas.TemplateApplicationsArgs =
        com.pulumi.alicloud.quotas.TemplateApplicationsArgs.builder()
            .aliyunUids(aliyunUids?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .desireValue(desireValue?.applyValue({ args0 -> args0 }))
            .dimensions(
                dimensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .effectiveTime(effectiveTime?.applyValue({ args0 -> args0 }))
            .envLanguage(envLanguage?.applyValue({ args0 -> args0 }))
            .expireTime(expireTime?.applyValue({ args0 -> args0 }))
            .noticeType(noticeType?.applyValue({ args0 -> args0 }))
            .productCode(productCode?.applyValue({ args0 -> args0 }))
            .quotaActionCode(quotaActionCode?.applyValue({ args0 -> args0 }))
            .quotaCategory(quotaCategory?.applyValue({ args0 -> args0 }))
            .reason(reason?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TemplateApplicationsArgs].
 */
@PulumiTagMarker
public class TemplateApplicationsArgsBuilder internal constructor() {
    private var aliyunUids: Output<List<String>>? = null

    private var desireValue: Output<Double>? = null

    private var dimensions: Output<List<TemplateApplicationsDimensionArgs>>? = null

    private var effectiveTime: Output<String>? = null

    private var envLanguage: Output<String>? = null

    private var expireTime: Output<String>? = null

    private var noticeType: Output<Int>? = null

    private var productCode: Output<String>? = null

    private var quotaActionCode: Output<String>? = null

    private var quotaCategory: Output<String>? = null

    private var reason: Output<String>? = null

    /**
     * @param value The list of Alibaba Cloud accounts (primary accounts) of the resource directory members to which the quota is applied.
     * > **NOTE:**  Only 50 members can apply for quota increase in batch at a time. For more information about the members of the resource directory, see Query the list of all members in the resource directory.
     */
    @JvmName("oyopbjrycayyjama")
    public suspend fun aliyunUids(`value`: Output<List<String>>) {
        this.aliyunUids = value
    }

    @JvmName("pcxuwflnbjhdjook")
    public suspend fun aliyunUids(vararg values: Output<String>) {
        this.aliyunUids = Output.all(values.asList())
    }

    /**
     * @param values The list of Alibaba Cloud accounts (primary accounts) of the resource directory members to which the quota is applied.
     * > **NOTE:**  Only 50 members can apply for quota increase in batch at a time. For more information about the members of the resource directory, see Query the list of all members in the resource directory.
     */
    @JvmName("efqjuuiubrfsqpru")
    public suspend fun aliyunUids(values: List<Output<String>>) {
        this.aliyunUids = Output.all(values)
    }

    /**
     * @param value The value of the quota request.
     * > **NOTE:**  The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
     */
    @JvmName("amhsvlbauuewiiub")
    public suspend fun desireValue(`value`: Output<Double>) {
        this.desireValue = value
    }

    /**
     * @param value Quota dimension. See `dimensions` below.
     */
    @JvmName("uftevngmimwbcuue")
    public suspend fun dimensions(`value`: Output<List<TemplateApplicationsDimensionArgs>>) {
        this.dimensions = value
    }

    @JvmName("fubmuqiimftalyhr")
    public suspend fun dimensions(vararg values: Output<TemplateApplicationsDimensionArgs>) {
        this.dimensions = Output.all(values.asList())
    }

    /**
     * @param values Quota dimension. See `dimensions` below.
     */
    @JvmName("bnhfebmswsawhegy")
    public suspend fun dimensions(values: List<Output<TemplateApplicationsDimensionArgs>>) {
        this.dimensions = Output.all(values)
    }

    /**
     * @param value The UTC time when the quota takes effect. This parameter applies only to the equity quota (WhiteListLabel).
     * > **NOTE:**  If the current account does not select the effective time, the default is the submission time.
     */
    @JvmName("feynrmoitwskdjsm")
    public suspend fun effectiveTime(`value`: Output<String>) {
        this.effectiveTime = value
    }

    /**
     * @param value The language of the quota application result notification. Value:
     * - zh (default): Chinese.
     * - en: English.
     */
    @JvmName("bppguvnibhjxguqb")
    public suspend fun envLanguage(`value`: Output<String>) {
        this.envLanguage = value
    }

    /**
     * @param value The UTC time when the quota expires. This parameter applies only to the equity quota (WhiteListLabel).
     * > **NOTE:**  If No Expiration Time is selected for the current account, the expiration time is 99 years from the effective time of the current quota.
     */
    @JvmName("erkkurrrkfvxogxu")
    public suspend fun expireTime(`value`: Output<String>) {
        this.expireTime = value
    }

    /**
     * @param value Whether to send notification of quota application result. Value:
     * - 0 (default): No.
     * - 3: Yes.
     */
    @JvmName("qjoqxcudlynumlve")
    public suspend fun noticeType(`value`: Output<Int>) {
        this.noticeType = value
    }

    /**
     * @param value Cloud service name abbreviation.
     * > **NOTE:**  For more information about cloud services that support quota centers, see Cloud services that support quota centers.
     */
    @JvmName("lxryaenmrshqxkpl")
    public suspend fun productCode(`value`: Output<String>) {
        this.productCode = value
    }

    /**
     * @param value The quota ID.
     */
    @JvmName("vkihvlrtdsdhaafu")
    public suspend fun quotaActionCode(`value`: Output<String>) {
        this.quotaActionCode = value
    }

    /**
     * @param value The quota type. Value:
     * - CommonQuota (default): Generic quota.
     * - FlowControl:API rate quota.
     * - WhiteListLabel: Equity quota.
     */
    @JvmName("mqvdpotpmejisjfq")
    public suspend fun quotaCategory(`value`: Output<String>) {
        this.quotaCategory = value
    }

    /**
     * @param value Reason for quota application.
     * > **NOTE:**  The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
     */
    @JvmName("hclnhvwtacfjspxi")
    public suspend fun reason(`value`: Output<String>) {
        this.reason = value
    }

    /**
     * @param value The list of Alibaba Cloud accounts (primary accounts) of the resource directory members to which the quota is applied.
     * > **NOTE:**  Only 50 members can apply for quota increase in batch at a time. For more information about the members of the resource directory, see Query the list of all members in the resource directory.
     */
    @JvmName("njjkmnllyytvvyuw")
    public suspend fun aliyunUids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aliyunUids = mapped
    }

    /**
     * @param values The list of Alibaba Cloud accounts (primary accounts) of the resource directory members to which the quota is applied.
     * > **NOTE:**  Only 50 members can apply for quota increase in batch at a time. For more information about the members of the resource directory, see Query the list of all members in the resource directory.
     */
    @JvmName("ttghsnfjjokrjver")
    public suspend fun aliyunUids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aliyunUids = mapped
    }

    /**
     * @param value The value of the quota request.
     * > **NOTE:**  The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
     */
    @JvmName("mfyigiigwgmktjpy")
    public suspend fun desireValue(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desireValue = mapped
    }

    /**
     * @param value Quota dimension. See `dimensions` below.
     */
    @JvmName("iuhtudkjvfryttjq")
    public suspend fun dimensions(`value`: List<TemplateApplicationsDimensionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param argument Quota dimension. See `dimensions` below.
     */
    @JvmName("oqvwluvlcgvrjffa")
    public suspend fun dimensions(argument: List<suspend TemplateApplicationsDimensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TemplateApplicationsDimensionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument Quota dimension. See `dimensions` below.
     */
    @JvmName("dritqkgdyosloukm")
    public suspend fun dimensions(vararg argument: suspend TemplateApplicationsDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TemplateApplicationsDimensionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument Quota dimension. See `dimensions` below.
     */
    @JvmName("mtioufuoepqgumax")
    public suspend fun dimensions(argument: suspend TemplateApplicationsDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TemplateApplicationsDimensionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param values Quota dimension. See `dimensions` below.
     */
    @JvmName("lkytuwuomlxvlfdm")
    public suspend fun dimensions(vararg values: TemplateApplicationsDimensionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param value The UTC time when the quota takes effect. This parameter applies only to the equity quota (WhiteListLabel).
     * > **NOTE:**  If the current account does not select the effective time, the default is the submission time.
     */
    @JvmName("ogesqghsadmmbpfe")
    public suspend fun effectiveTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effectiveTime = mapped
    }

    /**
     * @param value The language of the quota application result notification. Value:
     * - zh (default): Chinese.
     * - en: English.
     */
    @JvmName("wbwpsyldgriaescc")
    public suspend fun envLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.envLanguage = mapped
    }

    /**
     * @param value The UTC time when the quota expires. This parameter applies only to the equity quota (WhiteListLabel).
     * > **NOTE:**  If No Expiration Time is selected for the current account, the expiration time is 99 years from the effective time of the current quota.
     */
    @JvmName("kppksodyfxmnjvmk")
    public suspend fun expireTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expireTime = mapped
    }

    /**
     * @param value Whether to send notification of quota application result. Value:
     * - 0 (default): No.
     * - 3: Yes.
     */
    @JvmName("vbvnwybdmrbfvugp")
    public suspend fun noticeType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noticeType = mapped
    }

    /**
     * @param value Cloud service name abbreviation.
     * > **NOTE:**  For more information about cloud services that support quota centers, see Cloud services that support quota centers.
     */
    @JvmName("rdrmmbybfbekkbql")
    public suspend fun productCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productCode = mapped
    }

    /**
     * @param value The quota ID.
     */
    @JvmName("oxqqkfyxfwcgrpsi")
    public suspend fun quotaActionCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quotaActionCode = mapped
    }

    /**
     * @param value The quota type. Value:
     * - CommonQuota (default): Generic quota.
     * - FlowControl:API rate quota.
     * - WhiteListLabel: Equity quota.
     */
    @JvmName("uypbdgisfrewkrjo")
    public suspend fun quotaCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quotaCategory = mapped
    }

    /**
     * @param value Reason for quota application.
     * > **NOTE:**  The quota request is approved by the technical support of each cloud service. If you want to increase the chance of passing, please fill in a reasonable application value and detailed application reasons when applying for quota.
     */
    @JvmName("sohdtsbglampvqaq")
    public suspend fun reason(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reason = mapped
    }

    internal fun build(): TemplateApplicationsArgs = TemplateApplicationsArgs(
        aliyunUids = aliyunUids,
        desireValue = desireValue,
        dimensions = dimensions,
        effectiveTime = effectiveTime,
        envLanguage = envLanguage,
        expireTime = expireTime,
        noticeType = noticeType,
        productCode = productCode,
        quotaActionCode = quotaActionCode,
        quotaCategory = quotaCategory,
        reason = reason,
    )
}
