@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin

import com.pulumi.alicloud.quotas.kotlin.outputs.TemplateQuotaDimension
import com.pulumi.alicloud.quotas.kotlin.outputs.TemplateQuotaDimension.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [TemplateQuota].
 */
@PulumiTagMarker
public class TemplateQuotaResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TemplateQuotaArgs = TemplateQuotaArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TemplateQuotaArgsBuilder.() -> Unit) {
        val builder = TemplateQuotaArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TemplateQuota {
        val builtJavaResource = com.pulumi.alicloud.quotas.TemplateQuota(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TemplateQuota(builtJavaResource)
    }
}

/**
 * Provides a Quotas Template Quota resource.
 * For information about Quotas Template Quota and how to use it, see [What is Template Quota](https://www.alibabacloud.com/help/en/quota-center/developer-reference/api-quotas-2020-05-10-createtemplatequotaitem).
 * > **NOTE:** Available since v1.206.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.quotas.TemplateQuota("default", {
 *     quotaActionCode: "q_desktop-count",
 *     productCode: "gws",
 *     noticeType: 3,
 *     dimensions: [{
 *         key: "regionId",
 *         value: "cn-hangzhou",
 *     }],
 *     desireValue: 1001,
 *     envLanguage: "zh",
 *     quotaCategory: "CommonQuota",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.quotas.TemplateQuota("default",
 *     quota_action_code="q_desktop-count",
 *     product_code="gws",
 *     notice_type=3,
 *     dimensions=[{
 *         "key": "regionId",
 *         "value": "cn-hangzhou",
 *     }],
 *     desire_value=1001,
 *     env_language="zh",
 *     quota_category="CommonQuota")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Quotas.TemplateQuota("default", new()
 *     {
 *         QuotaActionCode = "q_desktop-count",
 *         ProductCode = "gws",
 *         NoticeType = 3,
 *         Dimensions = new[]
 *         {
 *             new AliCloud.Quotas.Inputs.TemplateQuotaDimensionArgs
 *             {
 *                 Key = "regionId",
 *                 Value = "cn-hangzhou",
 *             },
 *         },
 *         DesireValue = 1001,
 *         EnvLanguage = "zh",
 *         QuotaCategory = "CommonQuota",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/quotas"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := quotas.NewTemplateQuota(ctx, "default", &quotas.TemplateQuotaArgs{
 * 			QuotaActionCode: pulumi.String("q_desktop-count"),
 * 			ProductCode:     pulumi.String("gws"),
 * 			NoticeType:      pulumi.Int(3),
 * 			Dimensions: quotas.TemplateQuotaDimensionArray{
 * 				&quotas.TemplateQuotaDimensionArgs{
 * 					Key:   pulumi.String("regionId"),
 * 					Value: pulumi.String("cn-hangzhou"),
 * 				},
 * 			},
 * 			DesireValue:   pulumi.Float64(1001),
 * 			EnvLanguage:   pulumi.String("zh"),
 * 			QuotaCategory: pulumi.String("CommonQuota"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.quotas.TemplateQuota;
 * import com.pulumi.alicloud.quotas.TemplateQuotaArgs;
 * import com.pulumi.alicloud.quotas.inputs.TemplateQuotaDimensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new TemplateQuota("default", TemplateQuotaArgs.builder()
 *             .quotaActionCode("q_desktop-count")
 *             .productCode("gws")
 *             .noticeType(3)
 *             .dimensions(TemplateQuotaDimensionArgs.builder()
 *                 .key("regionId")
 *                 .value("cn-hangzhou")
 *                 .build())
 *             .desireValue(1001)
 *             .envLanguage("zh")
 *             .quotaCategory("CommonQuota")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:quotas:TemplateQuota
 *     properties:
 *       quotaActionCode: q_desktop-count
 *       productCode: gws
 *       noticeType: 3
 *       dimensions:
 *         - key: regionId
 *           value: cn-hangzhou
 *       desireValue: 1001
 *       envLanguage: zh
 *       quotaCategory: CommonQuota
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Quotas Template Quota can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:quotas/templateQuota:TemplateQuota example <id>
 * ```
 */
public class TemplateQuota internal constructor(
    override val javaResource: com.pulumi.alicloud.quotas.TemplateQuota,
) : KotlinCustomResource(javaResource, TemplateQuotaMapper) {
    /**
     * Quota application value.
     */
    public val desireValue: Output<Double>
        get() = javaResource.desireValue().applyValue({ args0 -> args0 })

    /**
     * The Quota Dimensions. See `dimensions` below.
     */
    public val dimensions: Output<List<TemplateQuotaDimension>>?
        get() = javaResource.dimensions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The UTC time when the quota takes effect.
     */
    public val effectiveTime: Output<String>?
        get() = javaResource.effectiveTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The language of the quota alert notification. Value:
     * - zh: Chinese.
     * - en: English.
     */
    public val envLanguage: Output<String>
        get() = javaResource.envLanguage().applyValue({ args0 -> args0 })

    /**
     * The UTC time when the quota expires.
     */
    public val expireTime: Output<String>?
        get() = javaResource.expireTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to notify the result of quota promotion application. Value:
     * - 0: No.
     * - 3: Yes.
     */
    public val noticeType: Output<Int>
        get() = javaResource.noticeType().applyValue({ args0 -> args0 })

    /**
     * The abbreviation of the cloud service name.
     */
    public val productCode: Output<String>
        get() = javaResource.productCode().applyValue({ args0 -> args0 })

    /**
     * The quota ID.
     */
    public val quotaActionCode: Output<String>
        get() = javaResource.quotaActionCode().applyValue({ args0 -> args0 })

    /**
     * Type of quota. Value:
     * - CommonQuota : Generic quota.
     * - WhiteListLabel: Equity quota.
     * - FlowControl:API rate quota.
     */
    public val quotaCategory: Output<String>?
        get() = javaResource.quotaCategory().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object TemplateQuotaMapper : ResourceMapper<TemplateQuota> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.quotas.TemplateQuota::class == javaResource::class

    override fun map(javaResource: Resource): TemplateQuota = TemplateQuota(
        javaResource as
            com.pulumi.alicloud.quotas.TemplateQuota,
    )
}

/**
 * @see [TemplateQuota].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TemplateQuota].
 */
public suspend fun templateQuota(
    name: String,
    block: suspend TemplateQuotaResourceBuilder.() -> Unit,
): TemplateQuota {
    val builder = TemplateQuotaResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TemplateQuota].
 * @param name The _unique_ name of the resulting resource.
 */
public fun templateQuota(name: String): TemplateQuota {
    val builder = TemplateQuotaResourceBuilder()
    builder.name(name)
    return builder.build()
}
