@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin

import com.pulumi.alicloud.quotas.TemplateQuotaArgs.builder
import com.pulumi.alicloud.quotas.kotlin.inputs.TemplateQuotaDimensionArgs
import com.pulumi.alicloud.quotas.kotlin.inputs.TemplateQuotaDimensionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Quotas Template Quota resource.
 * For information about Quotas Template Quota and how to use it, see [What is Template Quota](https://www.alibabacloud.com/help/en/quota-center/developer-reference/api-quotas-2020-05-10-createtemplatequotaitem).
 * > **NOTE:** Available since v1.206.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.quotas.TemplateQuota("default", {
 *     quotaActionCode: "q_desktop-count",
 *     productCode: "gws",
 *     noticeType: 3,
 *     dimensions: [{
 *         key: "regionId",
 *         value: "cn-hangzhou",
 *     }],
 *     desireValue: 1001,
 *     envLanguage: "zh",
 *     quotaCategory: "CommonQuota",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.quotas.TemplateQuota("default",
 *     quota_action_code="q_desktop-count",
 *     product_code="gws",
 *     notice_type=3,
 *     dimensions=[{
 *         "key": "regionId",
 *         "value": "cn-hangzhou",
 *     }],
 *     desire_value=1001,
 *     env_language="zh",
 *     quota_category="CommonQuota")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Quotas.TemplateQuota("default", new()
 *     {
 *         QuotaActionCode = "q_desktop-count",
 *         ProductCode = "gws",
 *         NoticeType = 3,
 *         Dimensions = new[]
 *         {
 *             new AliCloud.Quotas.Inputs.TemplateQuotaDimensionArgs
 *             {
 *                 Key = "regionId",
 *                 Value = "cn-hangzhou",
 *             },
 *         },
 *         DesireValue = 1001,
 *         EnvLanguage = "zh",
 *         QuotaCategory = "CommonQuota",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/quotas"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := quotas.NewTemplateQuota(ctx, "default", &quotas.TemplateQuotaArgs{
 * 			QuotaActionCode: pulumi.String("q_desktop-count"),
 * 			ProductCode:     pulumi.String("gws"),
 * 			NoticeType:      pulumi.Int(3),
 * 			Dimensions: quotas.TemplateQuotaDimensionArray{
 * 				&quotas.TemplateQuotaDimensionArgs{
 * 					Key:   pulumi.String("regionId"),
 * 					Value: pulumi.String("cn-hangzhou"),
 * 				},
 * 			},
 * 			DesireValue:   pulumi.Float64(1001),
 * 			EnvLanguage:   pulumi.String("zh"),
 * 			QuotaCategory: pulumi.String("CommonQuota"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.quotas.TemplateQuota;
 * import com.pulumi.alicloud.quotas.TemplateQuotaArgs;
 * import com.pulumi.alicloud.quotas.inputs.TemplateQuotaDimensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new TemplateQuota("default", TemplateQuotaArgs.builder()
 *             .quotaActionCode("q_desktop-count")
 *             .productCode("gws")
 *             .noticeType(3)
 *             .dimensions(TemplateQuotaDimensionArgs.builder()
 *                 .key("regionId")
 *                 .value("cn-hangzhou")
 *                 .build())
 *             .desireValue(1001)
 *             .envLanguage("zh")
 *             .quotaCategory("CommonQuota")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:quotas:TemplateQuota
 *     properties:
 *       quotaActionCode: q_desktop-count
 *       productCode: gws
 *       noticeType: 3
 *       dimensions:
 *         - key: regionId
 *           value: cn-hangzhou
 *       desireValue: 1001
 *       envLanguage: zh
 *       quotaCategory: CommonQuota
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Quotas Template Quota can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:quotas/templateQuota:TemplateQuota example <id>
 * ```
 * @property desireValue Quota application value.
 * @property dimensions The Quota Dimensions. See `dimensions` below.
 * @property effectiveTime The UTC time when the quota takes effect.
 * @property envLanguage The language of the quota alert notification. Value:
 * - zh: Chinese.
 * - en: English.
 * @property expireTime The UTC time when the quota expires.
 * @property noticeType Whether to notify the result of quota promotion application. Value:
 * - 0: No.
 * - 3: Yes.
 * @property productCode The abbreviation of the cloud service name.
 * @property quotaActionCode The quota ID.
 * @property quotaCategory Type of quota. Value:
 * - CommonQuota : Generic quota.
 * - WhiteListLabel: Equity quota.
 * - FlowControl:API rate quota.
 */
public data class TemplateQuotaArgs(
    public val desireValue: Output<Double>? = null,
    public val dimensions: Output<List<TemplateQuotaDimensionArgs>>? = null,
    public val effectiveTime: Output<String>? = null,
    public val envLanguage: Output<String>? = null,
    public val expireTime: Output<String>? = null,
    public val noticeType: Output<Int>? = null,
    public val productCode: Output<String>? = null,
    public val quotaActionCode: Output<String>? = null,
    public val quotaCategory: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.quotas.TemplateQuotaArgs> {
    override fun toJava(): com.pulumi.alicloud.quotas.TemplateQuotaArgs =
        com.pulumi.alicloud.quotas.TemplateQuotaArgs.builder()
            .desireValue(desireValue?.applyValue({ args0 -> args0 }))
            .dimensions(
                dimensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .effectiveTime(effectiveTime?.applyValue({ args0 -> args0 }))
            .envLanguage(envLanguage?.applyValue({ args0 -> args0 }))
            .expireTime(expireTime?.applyValue({ args0 -> args0 }))
            .noticeType(noticeType?.applyValue({ args0 -> args0 }))
            .productCode(productCode?.applyValue({ args0 -> args0 }))
            .quotaActionCode(quotaActionCode?.applyValue({ args0 -> args0 }))
            .quotaCategory(quotaCategory?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TemplateQuotaArgs].
 */
@PulumiTagMarker
public class TemplateQuotaArgsBuilder internal constructor() {
    private var desireValue: Output<Double>? = null

    private var dimensions: Output<List<TemplateQuotaDimensionArgs>>? = null

    private var effectiveTime: Output<String>? = null

    private var envLanguage: Output<String>? = null

    private var expireTime: Output<String>? = null

    private var noticeType: Output<Int>? = null

    private var productCode: Output<String>? = null

    private var quotaActionCode: Output<String>? = null

    private var quotaCategory: Output<String>? = null

    /**
     * @param value Quota application value.
     */
    @JvmName("gwhvuqdagotwfbtx")
    public suspend fun desireValue(`value`: Output<Double>) {
        this.desireValue = value
    }

    /**
     * @param value The Quota Dimensions. See `dimensions` below.
     */
    @JvmName("yphdqfrqobsdybmr")
    public suspend fun dimensions(`value`: Output<List<TemplateQuotaDimensionArgs>>) {
        this.dimensions = value
    }

    @JvmName("sgorcwulhglelowe")
    public suspend fun dimensions(vararg values: Output<TemplateQuotaDimensionArgs>) {
        this.dimensions = Output.all(values.asList())
    }

    /**
     * @param values The Quota Dimensions. See `dimensions` below.
     */
    @JvmName("cgqjurbijyxabcun")
    public suspend fun dimensions(values: List<Output<TemplateQuotaDimensionArgs>>) {
        this.dimensions = Output.all(values)
    }

    /**
     * @param value The UTC time when the quota takes effect.
     */
    @JvmName("mbsmfwjgiomlijgl")
    public suspend fun effectiveTime(`value`: Output<String>) {
        this.effectiveTime = value
    }

    /**
     * @param value The language of the quota alert notification. Value:
     * - zh: Chinese.
     * - en: English.
     */
    @JvmName("fsdbivsysvqmdfql")
    public suspend fun envLanguage(`value`: Output<String>) {
        this.envLanguage = value
    }

    /**
     * @param value The UTC time when the quota expires.
     */
    @JvmName("pwwnievgeicgyqvi")
    public suspend fun expireTime(`value`: Output<String>) {
        this.expireTime = value
    }

    /**
     * @param value Whether to notify the result of quota promotion application. Value:
     * - 0: No.
     * - 3: Yes.
     */
    @JvmName("udduvcextibimlbb")
    public suspend fun noticeType(`value`: Output<Int>) {
        this.noticeType = value
    }

    /**
     * @param value The abbreviation of the cloud service name.
     */
    @JvmName("finyjibkdjwusevc")
    public suspend fun productCode(`value`: Output<String>) {
        this.productCode = value
    }

    /**
     * @param value The quota ID.
     */
    @JvmName("pvftgnduiqevacsq")
    public suspend fun quotaActionCode(`value`: Output<String>) {
        this.quotaActionCode = value
    }

    /**
     * @param value Type of quota. Value:
     * - CommonQuota : Generic quota.
     * - WhiteListLabel: Equity quota.
     * - FlowControl:API rate quota.
     */
    @JvmName("bfyfyxsikqhsyivu")
    public suspend fun quotaCategory(`value`: Output<String>) {
        this.quotaCategory = value
    }

    /**
     * @param value Quota application value.
     */
    @JvmName("hwmdphvombfniskw")
    public suspend fun desireValue(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desireValue = mapped
    }

    /**
     * @param value The Quota Dimensions. See `dimensions` below.
     */
    @JvmName("utlprhydmtmurhth")
    public suspend fun dimensions(`value`: List<TemplateQuotaDimensionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param argument The Quota Dimensions. See `dimensions` below.
     */
    @JvmName("btlmyccmvwmoydyt")
    public suspend fun dimensions(argument: List<suspend TemplateQuotaDimensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TemplateQuotaDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument The Quota Dimensions. See `dimensions` below.
     */
    @JvmName("obriufgidcmkmies")
    public suspend fun dimensions(vararg argument: suspend TemplateQuotaDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TemplateQuotaDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument The Quota Dimensions. See `dimensions` below.
     */
    @JvmName("ysnbjpkbgqyaumwo")
    public suspend fun dimensions(argument: suspend TemplateQuotaDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TemplateQuotaDimensionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param values The Quota Dimensions. See `dimensions` below.
     */
    @JvmName("wrokdgnewsyobktt")
    public suspend fun dimensions(vararg values: TemplateQuotaDimensionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param value The UTC time when the quota takes effect.
     */
    @JvmName("lqwoksiwxggbnkpt")
    public suspend fun effectiveTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effectiveTime = mapped
    }

    /**
     * @param value The language of the quota alert notification. Value:
     * - zh: Chinese.
     * - en: English.
     */
    @JvmName("voxuhicwglashaem")
    public suspend fun envLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.envLanguage = mapped
    }

    /**
     * @param value The UTC time when the quota expires.
     */
    @JvmName("bqoiwdomhjhbrmli")
    public suspend fun expireTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expireTime = mapped
    }

    /**
     * @param value Whether to notify the result of quota promotion application. Value:
     * - 0: No.
     * - 3: Yes.
     */
    @JvmName("ldtqbsesbvgnjsie")
    public suspend fun noticeType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noticeType = mapped
    }

    /**
     * @param value The abbreviation of the cloud service name.
     */
    @JvmName("shyktcfrscxqcdlm")
    public suspend fun productCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productCode = mapped
    }

    /**
     * @param value The quota ID.
     */
    @JvmName("cjxdbfeicnknxsrx")
    public suspend fun quotaActionCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quotaActionCode = mapped
    }

    /**
     * @param value Type of quota. Value:
     * - CommonQuota : Generic quota.
     * - WhiteListLabel: Equity quota.
     * - FlowControl:API rate quota.
     */
    @JvmName("bestlukfbnqadeoe")
    public suspend fun quotaCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quotaCategory = mapped
    }

    internal fun build(): TemplateQuotaArgs = TemplateQuotaArgs(
        desireValue = desireValue,
        dimensions = dimensions,
        effectiveTime = effectiveTime,
        envLanguage = envLanguage,
        expireTime = expireTime,
        noticeType = noticeType,
        productCode = productCode,
        quotaActionCode = quotaActionCode,
        quotaCategory = quotaCategory,
    )
}
