@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin.inputs

import com.pulumi.alicloud.quotas.inputs.GetApplicationInfosPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getApplicationInfos.
 * @property dimensions
 * @property enableDetails
 * @property ids
 * @property keyWord
 * @property outputFile
 * @property productCode
 * @property quotaActionCode
 * @property quotaCategory
 * @property status
 */
public data class GetApplicationInfosPlainArgs(
    public val dimensions: List<GetApplicationInfosDimension>? = null,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val keyWord: String? = null,
    public val outputFile: String? = null,
    public val productCode: String,
    public val quotaActionCode: String? = null,
    public val quotaCategory: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.quotas.inputs.GetApplicationInfosPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.quotas.inputs.GetApplicationInfosPlainArgs =
        com.pulumi.alicloud.quotas.inputs.GetApplicationInfosPlainArgs.builder()
            .dimensions(
                dimensions?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .keyWord(keyWord?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .productCode(productCode.let({ args0 -> args0 }))
            .quotaActionCode(quotaActionCode?.let({ args0 -> args0 }))
            .quotaCategory(quotaCategory?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationInfosPlainArgs].
 */
@PulumiTagMarker
public class GetApplicationInfosPlainArgsBuilder internal constructor() {
    private var dimensions: List<GetApplicationInfosDimension>? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var keyWord: String? = null

    private var outputFile: String? = null

    private var productCode: String? = null

    private var quotaActionCode: String? = null

    private var quotaCategory: String? = null

    private var status: String? = null

    /**
     * @param value
     */
    @JvmName("rxjahbpvjjeedcky")
    public suspend fun dimensions(`value`: List<GetApplicationInfosDimension>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dimensions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qokxvlbmdbbpurkj")
    public suspend fun dimensions(argument: List<suspend GetApplicationInfosDimensionBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetApplicationInfosDimensionBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.dimensions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xgsmpbogxmdnwfqx")
    public suspend fun dimensions(vararg argument: suspend GetApplicationInfosDimensionBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetApplicationInfosDimensionBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.dimensions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hffooxwkocuynklj")
    public suspend fun dimensions(argument: suspend GetApplicationInfosDimensionBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetApplicationInfosDimensionBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.dimensions = mapped
    }

    /**
     * @param values
     */
    @JvmName("nckbvqsxilddbljs")
    public suspend fun dimensions(vararg values: GetApplicationInfosDimension) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dimensions = mapped
    }

    /**
     * @param value
     */
    @JvmName("mjamipmltcgvhxds")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value
     */
    @JvmName("rsfarqunoirkoysi")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values
     */
    @JvmName("shalaqioheurprqx")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value
     */
    @JvmName("thhfhlndegktqpmd")
    public suspend fun keyWord(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyWord = mapped
    }

    /**
     * @param value
     */
    @JvmName("otlfgucdefpvhxpy")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("wgomxjtbcxtogdjm")
    public suspend fun productCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.productCode = mapped
    }

    /**
     * @param value
     */
    @JvmName("nkuhduxqoropyuux")
    public suspend fun quotaActionCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.quotaActionCode = mapped
    }

    /**
     * @param value
     */
    @JvmName("drnsqqccjdonhrcl")
    public suspend fun quotaCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.quotaCategory = mapped
    }

    /**
     * @param value
     */
    @JvmName("hjplkmcyaldtowmc")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetApplicationInfosPlainArgs = GetApplicationInfosPlainArgs(
        dimensions = dimensions,
        enableDetails = enableDetails,
        ids = ids,
        keyWord = keyWord,
        outputFile = outputFile,
        productCode = productCode ?: throw PulumiNullFieldException("productCode"),
        quotaActionCode = quotaActionCode,
        quotaCategory = quotaCategory,
        status = status,
    )
}
