@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin.inputs

import com.pulumi.alicloud.quotas.inputs.GetQuotaAlarmsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getQuotaAlarms.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Quota Alarm IDs.
 * @property nameRegex A regex string to filter results by Quota Alarm name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property productCode The Product Code.
 * @property quotaActionCode The Quota Action Code.
 * @property quotaAlarmName The name of Quota Alarm.
 * @property quotaDimensions The Quota Dimensions.
 */
public data class GetQuotaAlarmsPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val productCode: String? = null,
    public val quotaActionCode: String? = null,
    public val quotaAlarmName: String? = null,
    public val quotaDimensions: List<GetQuotaAlarmsQuotaDimension>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.quotas.inputs.GetQuotaAlarmsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.quotas.inputs.GetQuotaAlarmsPlainArgs =
        com.pulumi.alicloud.quotas.inputs.GetQuotaAlarmsPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .productCode(productCode?.let({ args0 -> args0 }))
            .quotaActionCode(quotaActionCode?.let({ args0 -> args0 }))
            .quotaAlarmName(quotaAlarmName?.let({ args0 -> args0 }))
            .quotaDimensions(
                quotaDimensions?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetQuotaAlarmsPlainArgs].
 */
@PulumiTagMarker
public class GetQuotaAlarmsPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var productCode: String? = null

    private var quotaActionCode: String? = null

    private var quotaAlarmName: String? = null

    private var quotaDimensions: List<GetQuotaAlarmsQuotaDimension>? = null

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("opqwrioilroakfvy")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Quota Alarm IDs.
     */
    @JvmName("entgtruatnlasqir")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Quota Alarm IDs.
     */
    @JvmName("mikivgbrmusfujis")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Quota Alarm name.
     */
    @JvmName("npdrrkwxuvjwxjsm")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("iocosgmqeukpbiyo")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The Product Code.
     */
    @JvmName("vnripfbvxxlamayl")
    public suspend fun productCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.productCode = mapped
    }

    /**
     * @param value The Quota Action Code.
     */
    @JvmName("kgeseuoibcogdcvt")
    public suspend fun quotaActionCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.quotaActionCode = mapped
    }

    /**
     * @param value The name of Quota Alarm.
     */
    @JvmName("ckvnttiamowpktth")
    public suspend fun quotaAlarmName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.quotaAlarmName = mapped
    }

    /**
     * @param value The Quota Dimensions.
     */
    @JvmName("igofpqybkmlhdevy")
    public suspend fun quotaDimensions(`value`: List<GetQuotaAlarmsQuotaDimension>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.quotaDimensions = mapped
    }

    /**
     * @param argument The Quota Dimensions.
     */
    @JvmName("fenntwhjbifgcfxg")
    public suspend fun quotaDimensions(argument: List<suspend GetQuotaAlarmsQuotaDimensionBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetQuotaAlarmsQuotaDimensionBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.quotaDimensions = mapped
    }

    /**
     * @param argument The Quota Dimensions.
     */
    @JvmName("wmcuwelojtrsmacu")
    public suspend fun quotaDimensions(vararg argument: suspend GetQuotaAlarmsQuotaDimensionBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetQuotaAlarmsQuotaDimensionBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.quotaDimensions = mapped
    }

    /**
     * @param argument The Quota Dimensions.
     */
    @JvmName("rbmtfitknpsydrar")
    public suspend fun quotaDimensions(argument: suspend GetQuotaAlarmsQuotaDimensionBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetQuotaAlarmsQuotaDimensionBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.quotaDimensions = mapped
    }

    /**
     * @param values The Quota Dimensions.
     */
    @JvmName("uxuyfutlstoeipah")
    public suspend fun quotaDimensions(vararg values: GetQuotaAlarmsQuotaDimension) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.quotaDimensions = mapped
    }

    internal fun build(): GetQuotaAlarmsPlainArgs = GetQuotaAlarmsPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        productCode = productCode,
        quotaActionCode = quotaActionCode,
        quotaAlarmName = quotaAlarmName,
        quotaDimensions = quotaDimensions,
    )
}
