@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin.inputs

import com.pulumi.alicloud.quotas.inputs.GetQuotaApplicationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getQuotaApplications.
 * @property dimensions The quota dimensions.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Application Info IDs.
 * @property keyWord
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property productCode The product code.
 * @property quotaActionCode The ID of quota action.
 * @property quotaCategory The quota category. Valid values: `CommonQuota`, `FlowControl`, `WhiteListLabel`.
 * @property status The status of the quota application. Valid Values: `Agree`, `Disagree` and `Process`.
 */
public data class GetQuotaApplicationsPlainArgs(
    public val dimensions: List<GetQuotaApplicationsDimension>? = null,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val keyWord: String? = null,
    public val outputFile: String? = null,
    public val productCode: String,
    public val quotaActionCode: String? = null,
    public val quotaCategory: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.quotas.inputs.GetQuotaApplicationsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.quotas.inputs.GetQuotaApplicationsPlainArgs =
        com.pulumi.alicloud.quotas.inputs.GetQuotaApplicationsPlainArgs.builder()
            .dimensions(
                dimensions?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .keyWord(keyWord?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .productCode(productCode.let({ args0 -> args0 }))
            .quotaActionCode(quotaActionCode?.let({ args0 -> args0 }))
            .quotaCategory(quotaCategory?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetQuotaApplicationsPlainArgs].
 */
@PulumiTagMarker
public class GetQuotaApplicationsPlainArgsBuilder internal constructor() {
    private var dimensions: List<GetQuotaApplicationsDimension>? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var keyWord: String? = null

    private var outputFile: String? = null

    private var productCode: String? = null

    private var quotaActionCode: String? = null

    private var quotaCategory: String? = null

    private var status: String? = null

    /**
     * @param value The quota dimensions.
     */
    @JvmName("gkkhlhhaeukthcsc")
    public suspend fun dimensions(`value`: List<GetQuotaApplicationsDimension>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dimensions = mapped
    }

    /**
     * @param argument The quota dimensions.
     */
    @JvmName("defoaqfamokhhgsi")
    public suspend fun dimensions(argument: List<suspend GetQuotaApplicationsDimensionBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetQuotaApplicationsDimensionBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.dimensions = mapped
    }

    /**
     * @param argument The quota dimensions.
     */
    @JvmName("hqprusgfkrndttps")
    public suspend fun dimensions(vararg argument: suspend GetQuotaApplicationsDimensionBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetQuotaApplicationsDimensionBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.dimensions = mapped
    }

    /**
     * @param argument The quota dimensions.
     */
    @JvmName("mmwmbijhaopihthe")
    public suspend fun dimensions(argument: suspend GetQuotaApplicationsDimensionBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetQuotaApplicationsDimensionBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.dimensions = mapped
    }

    /**
     * @param values The quota dimensions.
     */
    @JvmName("wnvrduejbeydlcfv")
    public suspend fun dimensions(vararg values: GetQuotaApplicationsDimension) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dimensions = mapped
    }

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("aiwwjhkhsmlhiglm")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Application Info IDs.
     */
    @JvmName("vlawaofucoxnqowg")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Application Info IDs.
     */
    @JvmName("yedowdgmxvmfkvyo")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value
     */
    @JvmName("btocgmsxvxlamkdr")
    public suspend fun keyWord(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyWord = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("wrymeiqhrsphljwx")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The product code.
     */
    @JvmName("cibbhtipxlbfmhxc")
    public suspend fun productCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.productCode = mapped
    }

    /**
     * @param value The ID of quota action.
     */
    @JvmName("oejogbebxagwdlex")
    public suspend fun quotaActionCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.quotaActionCode = mapped
    }

    /**
     * @param value The quota category. Valid values: `CommonQuota`, `FlowControl`, `WhiteListLabel`.
     */
    @JvmName("oeomdckddtbtdtng")
    public suspend fun quotaCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.quotaCategory = mapped
    }

    /**
     * @param value The status of the quota application. Valid Values: `Agree`, `Disagree` and `Process`.
     */
    @JvmName("dwfjqgcdbjhenato")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetQuotaApplicationsPlainArgs = GetQuotaApplicationsPlainArgs(
        dimensions = dimensions,
        enableDetails = enableDetails,
        ids = ids,
        keyWord = keyWord,
        outputFile = outputFile,
        productCode = productCode ?: throw PulumiNullFieldException("productCode"),
        quotaActionCode = quotaActionCode,
        quotaCategory = quotaCategory,
        status = status,
    )
}
