@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin.inputs

import com.pulumi.alicloud.quotas.inputs.GetQuotasPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getQuotas.
 * @property dimensions The dimensions.
 * @property groupCode The group code.
 * @property keyWord The key word.
 * @property nameRegex A regex string to filter results by Quota name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property productCode The product code.
 * @property quotaActionCode The quota action code.
 * @property quotaCategory The category of quota. Valid Values: `FlowControl` and `CommonQuota`, `WhiteListLabel`.
 * @property sortField Cloud service ECS specification quota supports setting sorting fields. Valid Values: `TIME`, `TOTAL` and `RESERVED`.
 * @property sortOrder Ranking of cloud service ECS specification quota support. Valid Values: `Ascending` and `Descending`.
 */
public data class GetQuotasPlainArgs(
    public val dimensions: List<GetQuotasDimension>? = null,
    public val groupCode: String? = null,
    public val keyWord: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val productCode: String,
    public val quotaActionCode: String? = null,
    public val quotaCategory: String? = null,
    public val sortField: String? = null,
    public val sortOrder: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.quotas.inputs.GetQuotasPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.quotas.inputs.GetQuotasPlainArgs =
        com.pulumi.alicloud.quotas.inputs.GetQuotasPlainArgs.builder()
            .dimensions(
                dimensions?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .groupCode(groupCode?.let({ args0 -> args0 }))
            .keyWord(keyWord?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .productCode(productCode.let({ args0 -> args0 }))
            .quotaActionCode(quotaActionCode?.let({ args0 -> args0 }))
            .quotaCategory(quotaCategory?.let({ args0 -> args0 }))
            .sortField(sortField?.let({ args0 -> args0 }))
            .sortOrder(sortOrder?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetQuotasPlainArgs].
 */
@PulumiTagMarker
public class GetQuotasPlainArgsBuilder internal constructor() {
    private var dimensions: List<GetQuotasDimension>? = null

    private var groupCode: String? = null

    private var keyWord: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var productCode: String? = null

    private var quotaActionCode: String? = null

    private var quotaCategory: String? = null

    private var sortField: String? = null

    private var sortOrder: String? = null

    /**
     * @param value The dimensions.
     */
    @JvmName("shxjjdtscjjqxcjb")
    public suspend fun dimensions(`value`: List<GetQuotasDimension>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dimensions = mapped
    }

    /**
     * @param argument The dimensions.
     */
    @JvmName("dyasplvcnmvjyihg")
    public suspend fun dimensions(argument: List<suspend GetQuotasDimensionBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetQuotasDimensionBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.dimensions = mapped
    }

    /**
     * @param argument The dimensions.
     */
    @JvmName("csvrwibvqffytccf")
    public suspend fun dimensions(vararg argument: suspend GetQuotasDimensionBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetQuotasDimensionBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.dimensions = mapped
    }

    /**
     * @param argument The dimensions.
     */
    @JvmName("tlcsbbmgpyemvvqb")
    public suspend fun dimensions(argument: suspend GetQuotasDimensionBuilder.() -> Unit) {
        val toBeMapped = listOf(GetQuotasDimensionBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.dimensions = mapped
    }

    /**
     * @param values The dimensions.
     */
    @JvmName("avlsjassdrruyhnn")
    public suspend fun dimensions(vararg values: GetQuotasDimension) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dimensions = mapped
    }

    /**
     * @param value The group code.
     */
    @JvmName("pnjultftvdhqvlqj")
    public suspend fun groupCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.groupCode = mapped
    }

    /**
     * @param value The key word.
     */
    @JvmName("rugewkissiflwsla")
    public suspend fun keyWord(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyWord = mapped
    }

    /**
     * @param value A regex string to filter results by Quota name.
     */
    @JvmName("ruruuyaebwjssuwr")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("nxvllvswqmoyamcw")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The product code.
     */
    @JvmName("lqkpjxhdiqgnfxoc")
    public suspend fun productCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.productCode = mapped
    }

    /**
     * @param value The quota action code.
     */
    @JvmName("rmgphnttusnrfbin")
    public suspend fun quotaActionCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.quotaActionCode = mapped
    }

    /**
     * @param value The category of quota. Valid Values: `FlowControl` and `CommonQuota`, `WhiteListLabel`.
     */
    @JvmName("wobcdjjhpjruflda")
    public suspend fun quotaCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.quotaCategory = mapped
    }

    /**
     * @param value Cloud service ECS specification quota supports setting sorting fields. Valid Values: `TIME`, `TOTAL` and `RESERVED`.
     */
    @JvmName("wmiltfajlkxbajip")
    public suspend fun sortField(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sortField = mapped
    }

    /**
     * @param value Ranking of cloud service ECS specification quota support. Valid Values: `Ascending` and `Descending`.
     */
    @JvmName("ywyrrxwtuuofbgwl")
    public suspend fun sortOrder(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sortOrder = mapped
    }

    internal fun build(): GetQuotasPlainArgs = GetQuotasPlainArgs(
        dimensions = dimensions,
        groupCode = groupCode,
        keyWord = keyWord,
        nameRegex = nameRegex,
        outputFile = outputFile,
        productCode = productCode ?: throw PulumiNullFieldException("productCode"),
        quotaActionCode = quotaActionCode,
        quotaCategory = quotaCategory,
        sortField = sortField,
        sortOrder = sortOrder,
    )
}
