@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin.inputs

import com.pulumi.alicloud.quotas.inputs.GetTemplateApplicationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTemplateApplications.
 * @property batchQuotaApplicationId The ID of the quota application batch.
 * @property ids A list of Template Applications IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property productCode Cloud service name abbreviation.> For more information about cloud services that support quota centers, see Cloud services that support quota centers.
 * @property quotaActionCode The quota ID.
 * @property quotaCategory The quota type. Value: `CommonQuota`, `FlowControl` and `WhiteListLabel`.
 */
public data class GetTemplateApplicationsPlainArgs(
    public val batchQuotaApplicationId: String? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val productCode: String? = null,
    public val quotaActionCode: String? = null,
    public val quotaCategory: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.quotas.inputs.GetTemplateApplicationsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.quotas.inputs.GetTemplateApplicationsPlainArgs =
        com.pulumi.alicloud.quotas.inputs.GetTemplateApplicationsPlainArgs.builder()
            .batchQuotaApplicationId(batchQuotaApplicationId?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .productCode(productCode?.let({ args0 -> args0 }))
            .quotaActionCode(quotaActionCode?.let({ args0 -> args0 }))
            .quotaCategory(quotaCategory?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTemplateApplicationsPlainArgs].
 */
@PulumiTagMarker
public class GetTemplateApplicationsPlainArgsBuilder internal constructor() {
    private var batchQuotaApplicationId: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var productCode: String? = null

    private var quotaActionCode: String? = null

    private var quotaCategory: String? = null

    /**
     * @param value The ID of the quota application batch.
     */
    @JvmName("dtlxsqypaaiopube")
    public suspend fun batchQuotaApplicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.batchQuotaApplicationId = mapped
    }

    /**
     * @param value A list of Template Applications IDs.
     */
    @JvmName("nxmwncynhudxdtqr")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Template Applications IDs.
     */
    @JvmName("txxnwtplrwxwijxd")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("osvmybiiicgbvnjj")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Cloud service name abbreviation.> For more information about cloud services that support quota centers, see Cloud services that support quota centers.
     */
    @JvmName("whuracrrxhhopdny")
    public suspend fun productCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.productCode = mapped
    }

    /**
     * @param value The quota ID.
     */
    @JvmName("awisrfkuwcybomya")
    public suspend fun quotaActionCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.quotaActionCode = mapped
    }

    /**
     * @param value The quota type. Value: `CommonQuota`, `FlowControl` and `WhiteListLabel`.
     */
    @JvmName("vdcpromlbxnwxrak")
    public suspend fun quotaCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.quotaCategory = mapped
    }

    internal fun build(): GetTemplateApplicationsPlainArgs = GetTemplateApplicationsPlainArgs(
        batchQuotaApplicationId = batchQuotaApplicationId,
        ids = ids,
        outputFile = outputFile,
        productCode = productCode,
        quotaActionCode = quotaActionCode,
        quotaCategory = quotaCategory,
    )
}
