@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin.inputs

import com.pulumi.alicloud.quotas.inputs.QuotaAlarmQuotaDimensionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key The Key of quota_dimensions.
 * @property value The Value of quota_dimensions.
 */
public data class QuotaAlarmQuotaDimensionArgs(
    public val key: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.quotas.inputs.QuotaAlarmQuotaDimensionArgs> {
    override fun toJava(): com.pulumi.alicloud.quotas.inputs.QuotaAlarmQuotaDimensionArgs =
        com.pulumi.alicloud.quotas.inputs.QuotaAlarmQuotaDimensionArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QuotaAlarmQuotaDimensionArgs].
 */
@PulumiTagMarker
public class QuotaAlarmQuotaDimensionArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The Key of quota_dimensions.
     */
    @JvmName("pvwfqxsfmxebgplq")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The Value of quota_dimensions.
     */
    @JvmName("tkuexyttoedlvdah")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The Key of quota_dimensions.
     */
    @JvmName("oqrcpygxfidgofej")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The Value of quota_dimensions.
     */
    @JvmName("lavarxbhouacjuyc")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): QuotaAlarmQuotaDimensionArgs = QuotaAlarmQuotaDimensionArgs(
        key = key,
        `value` = `value`,
    )
}
