@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin.inputs

import com.pulumi.alicloud.quotas.inputs.QuotaApplicationDimensionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key Key.
 * @property value Value.
 */
public data class QuotaApplicationDimensionArgs(
    public val key: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.quotas.inputs.QuotaApplicationDimensionArgs> {
    override fun toJava(): com.pulumi.alicloud.quotas.inputs.QuotaApplicationDimensionArgs =
        com.pulumi.alicloud.quotas.inputs.QuotaApplicationDimensionArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QuotaApplicationDimensionArgs].
 */
@PulumiTagMarker
public class QuotaApplicationDimensionArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Key.
     */
    @JvmName("wbsvkdkkiqdaqllx")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Value.
     */
    @JvmName("hfbpnbcgpqhymvfv")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Key.
     */
    @JvmName("lcjepryxrpdxduvu")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Value.
     */
    @JvmName("tsacnfwqawydftgq")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): QuotaApplicationDimensionArgs = QuotaApplicationDimensionArgs(
        key = key,
        `value` = `value`,
    )
}
