@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin.inputs

import com.pulumi.alicloud.quotas.inputs.TemplateApplicationsDimensionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key Quota dimension Key.
 * @property value Quota dimension Value.
 */
public data class TemplateApplicationsDimensionArgs(
    public val key: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.quotas.inputs.TemplateApplicationsDimensionArgs> {
    override fun toJava(): com.pulumi.alicloud.quotas.inputs.TemplateApplicationsDimensionArgs =
        com.pulumi.alicloud.quotas.inputs.TemplateApplicationsDimensionArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TemplateApplicationsDimensionArgs].
 */
@PulumiTagMarker
public class TemplateApplicationsDimensionArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Quota dimension Key.
     */
    @JvmName("hskfjuvwdbohbdpd")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Quota dimension Value.
     */
    @JvmName("idvmeuhvxhygemab")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Quota dimension Key.
     */
    @JvmName("bherhvponqakntts")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Quota dimension Value.
     */
    @JvmName("wrgxlekbifjhfxnv")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): TemplateApplicationsDimensionArgs = TemplateApplicationsDimensionArgs(
        key = key,
        `value` = `value`,
    )
}
