@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin.inputs

import com.pulumi.alicloud.quotas.inputs.TemplateQuotaDimensionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key The Key of quota_dimensions.
 * @property value The Value of quota_dimensions.
 */
public data class TemplateQuotaDimensionArgs(
    public val key: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.quotas.inputs.TemplateQuotaDimensionArgs> {
    override fun toJava(): com.pulumi.alicloud.quotas.inputs.TemplateQuotaDimensionArgs =
        com.pulumi.alicloud.quotas.inputs.TemplateQuotaDimensionArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TemplateQuotaDimensionArgs].
 */
@PulumiTagMarker
public class TemplateQuotaDimensionArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The Key of quota_dimensions.
     */
    @JvmName("amodsyfbhutiixqf")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The Value of quota_dimensions.
     */
    @JvmName("wbgcutlrjpgqhlkn")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The Key of quota_dimensions.
     */
    @JvmName("srliyejsgeycrgro")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The Value of quota_dimensions.
     */
    @JvmName("dujkcbahddlnrxus")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): TemplateQuotaDimensionArgs = TemplateQuotaDimensionArgs(
        key = key,
        `value` = `value`,
    )
}
