@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property applicationId
 * @property approveValue
 * @property auditReason
 * @property desireValue
 * @property dimensions
 * @property effectiveTime
 * @property expireTime
 * @property id
 * @property noticeType
 * @property productCode
 * @property quotaActionCode
 * @property quotaDescription
 * @property quotaName
 * @property quotaUnit
 * @property reason
 * @property status
 */
public data class GetApplicationInfosApplication(
    public val applicationId: String,
    public val approveValue: String,
    public val auditReason: String,
    public val desireValue: Double,
    public val dimensions: List<GetApplicationInfosApplicationDimension>,
    public val effectiveTime: String,
    public val expireTime: String,
    public val id: String,
    public val noticeType: Int,
    public val productCode: String,
    public val quotaActionCode: String,
    public val quotaDescription: String,
    public val quotaName: String,
    public val quotaUnit: String,
    public val reason: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.quotas.outputs.GetApplicationInfosApplication): GetApplicationInfosApplication = GetApplicationInfosApplication(
            applicationId = javaType.applicationId(),
            approveValue = javaType.approveValue(),
            auditReason = javaType.auditReason(),
            desireValue = javaType.desireValue(),
            dimensions = javaType.dimensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.quotas.kotlin.outputs.GetApplicationInfosApplicationDimension.Companion.toKotlin(args0)
                })
            }),
            effectiveTime = javaType.effectiveTime(),
            expireTime = javaType.expireTime(),
            id = javaType.id(),
            noticeType = javaType.noticeType(),
            productCode = javaType.productCode(),
            quotaActionCode = javaType.quotaActionCode(),
            quotaDescription = javaType.quotaDescription(),
            quotaName = javaType.quotaName(),
            quotaUnit = javaType.quotaUnit(),
            reason = javaType.reason(),
            status = javaType.status(),
        )
    }
}
