@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property alarmId The first ID of the resource.
 * @property id The ID of the Quota Alarm.
 * @property productCode The Product Code.
 * @property quotaActionCode The Quota Action Code.
 * @property quotaAlarmName The name of Quota Alarm.
 * @property quotaDimensions The Quota Dimensions.
 * @property threshold The threshold of Quota Alarm.
 * @property thresholdPercent The threshold percent of Quota Alarm.
 * @property webHook The WebHook of Quota Alarm.
 */
public data class GetQuotaAlarmsAlarm(
    public val alarmId: String,
    public val id: String,
    public val productCode: String,
    public val quotaActionCode: String,
    public val quotaAlarmName: String,
    public val quotaDimensions: List<GetQuotaAlarmsAlarmQuotaDimension>,
    public val threshold: Double,
    public val thresholdPercent: Double,
    public val webHook: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.quotas.outputs.GetQuotaAlarmsAlarm): GetQuotaAlarmsAlarm = GetQuotaAlarmsAlarm(
            alarmId = javaType.alarmId(),
            id = javaType.id(),
            productCode = javaType.productCode(),
            quotaActionCode = javaType.quotaActionCode(),
            quotaAlarmName = javaType.quotaAlarmName(),
            quotaDimensions = javaType.quotaDimensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.quotas.kotlin.outputs.GetQuotaAlarmsAlarmQuotaDimension.Companion.toKotlin(args0)
                })
            }),
            threshold = javaType.threshold(),
            thresholdPercent = javaType.thresholdPercent(),
            webHook = javaType.webHook(),
        )
    }
}
