@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getQuotaAlarms.
 * @property alarms
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property productCode
 * @property quotaActionCode
 * @property quotaAlarmName
 * @property quotaDimensions
 */
public data class GetQuotaAlarmsResult(
    public val alarms: List<GetQuotaAlarmsAlarm>,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val productCode: String? = null,
    public val quotaActionCode: String? = null,
    public val quotaAlarmName: String? = null,
    public val quotaDimensions: List<GetQuotaAlarmsQuotaDimension>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.quotas.outputs.GetQuotaAlarmsResult): GetQuotaAlarmsResult = GetQuotaAlarmsResult(
            alarms = javaType.alarms().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.quotas.kotlin.outputs.GetQuotaAlarmsAlarm.Companion.toKotlin(args0)
                })
            }),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            productCode = javaType.productCode().map({ args0 -> args0 }).orElse(null),
            quotaActionCode = javaType.quotaActionCode().map({ args0 -> args0 }).orElse(null),
            quotaAlarmName = javaType.quotaAlarmName().map({ args0 -> args0 }).orElse(null),
            quotaDimensions = javaType.quotaDimensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.quotas.kotlin.outputs.GetQuotaAlarmsQuotaDimension.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
