@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.quotas.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property applicationId The first ID of the resource.
 * @property approveValue The approve value.
 * @property auditReason The audit reason.
 * @property desireValue The desire value of the quota application.
 * @property dimensions The quota dimensions.
 * @property effectiveTime The effective time.
 * @property expireTime The expire time.
 * @property id The ID of the Application Info.
 * @property noticeType The notice type.
 * @property productCode The product code.
 * @property quotaActionCode The ID of quota action..
 * @property quotaDescription The description of the quota.
 * @property quotaName The name of the quota.
 * @property quotaUnit The quota unit.
 * @property reason The reason of the quota application.
 * @property status The status of the quota application.
 */
public data class GetQuotaApplicationsApplication(
    public val applicationId: String,
    public val approveValue: String,
    public val auditReason: String,
    public val desireValue: Double,
    public val dimensions: List<GetQuotaApplicationsApplicationDimension>,
    public val effectiveTime: String,
    public val expireTime: String,
    public val id: String,
    public val noticeType: Int,
    public val productCode: String,
    public val quotaActionCode: String,
    public val quotaDescription: String,
    public val quotaName: String,
    public val quotaUnit: String,
    public val reason: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.quotas.outputs.GetQuotaApplicationsApplication): GetQuotaApplicationsApplication = GetQuotaApplicationsApplication(
            applicationId = javaType.applicationId(),
            approveValue = javaType.approveValue(),
            auditReason = javaType.auditReason(),
            desireValue = javaType.desireValue(),
            dimensions = javaType.dimensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.quotas.kotlin.outputs.GetQuotaApplicationsApplicationDimension.Companion.toKotlin(args0)
                })
            }),
            effectiveTime = javaType.effectiveTime(),
            expireTime = javaType.expireTime(),
            id = javaType.id(),
            noticeType = javaType.noticeType(),
            productCode = javaType.productCode(),
            quotaActionCode = javaType.quotaActionCode(),
            quotaDescription = javaType.quotaDescription(),
            quotaName = javaType.quotaName(),
            quotaUnit = javaType.quotaUnit(),
            reason = javaType.reason(),
            status = javaType.status(),
        )
    }
}
